/*
 * Decompiled with CFR 0.152.
 */
package jport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import jport.EnvGlobal;
import jport.HPort;
import jport.HPort3D;

public class Main {
    public static void main(String[] args) {
        EnvGlobal.init();
        final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        final JFrame frame = new JFrame("DataMelt porto");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JButton plot2d = new JButton("2D (HPlot2D)");
        plot2d.setPreferredSize(new Dimension(200, 50));
        plot2d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPort hp = HPort.get("Canvas", 600, 400);
                hp.visible();
                int w = hp.getFrame().getSize().width;
                int h = hp.getFrame().getSize().height;
                int x = (dim.width - w) / 2;
                int y = (dim.height - h) / 2;
                hp.getFrame().setLocation(x, y);
                hp.visible();
                frame.setVisible(false);
                frame.dispose();
            }
        });
        JButton plot3d = new JButton("3D (HPlot3D)");
        plot3d.setPreferredSize(new Dimension(200, 50));
        plot3d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPort3D hp = HPort3D.get("Canvas", 600, 400);
                int w = hp.getFrame().getSize().width;
                int h = hp.getFrame().getSize().height;
                int x = (dim.width - w) / 2;
                int y = (dim.height - h) / 2;
                hp.getFrame().setLocation(x, y);
                hp.visible();
                frame.setVisible(false);
                frame.dispose();
            }
        });
        frame.getContentPane().add((Component)plot2d, "West");
        frame.getContentPane().add((Component)plot3d, "East");
        frame.pack();
        int w = frame.getSize().width;
        int h = frame.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        frame.setLocation(x, y);
        frame.setVisible(true);
    }
}

