/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Math.Matrix;
import Catalano.Statistics.Correlations;
import Catalano.Statistics.Regression.ILinear;
import Catalano.Statistics.Regression.ISimpleRegression;
import Catalano.Statistics.Tools;

public class ExponentialRegression
implements ISimpleRegression,
ILinear {
    private double[] x;
    private double[] y;
    private double inclination;
    private double interception;

    public ExponentialRegression(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        double[] yy = Matrix.Log(y);
        this.inclination = Tools.Inclination(x, yy);
        this.interception = Math.exp(Tools.Interception(x, yy));
    }

    @Override
    public double getInclination() {
        return this.inclination;
    }

    @Override
    public void setInclination(double inclination) {
        this.inclination = inclination;
    }

    @Override
    public double getInterception() {
        return this.interception;
    }

    @Override
    public void setInterception(double interception) {
        this.interception = interception;
    }

    @Override
    public double Regression(double x) {
        return this.interception * Math.exp(this.inclination * x);
    }

    @Override
    public double[] Regression(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = this.interception * Math.exp(this.interception * x[i]);
        }
        return result;
    }

    @Override
    public double CoefficientOfDetermination() {
        double[] r = this.Regression(this.x);
        return Math.pow(Correlations.PearsonCorrelation(r, this.y), 2.0);
    }

    @Override
    public String toString() {
        return "y = " + String.format("%.4f", this.interception) + "exp(" + String.format("%.4f", this.inclination) + "x)";
    }
}

