/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Anova
implements IMercerKernel<double[]> {
    private int n;
    private int p;
    private double[][][] K;

    public Anova(int vectorLength, int subsequenceLength) {
        this.n = vectorLength;
        this.p = subsequenceLength;
        this.K = new double[vectorLength][vectorLength][subsequenceLength];
    }

    @Override
    public double Function(double[] x, double[] y) {
        for (int k = 0; k < this.p; ++k) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.K[i][j][k] = this.kernel(x, i, y, j, k);
                }
            }
        }
        return this.K[this.n - 1][this.n - 1][this.p - 1];
    }

    private double kernel(double[] x, int ni, double[] y, int mi, int pi) {
        double a = ni == 0 || mi == 0 ? 0.0 : this.K[ni - 1][mi - 1][pi];
        double k = x[ni] * y[mi];
        if (pi == 0) {
            return a + k;
        }
        if (ni == 0 || mi == 0) {
            return a;
        }
        return a + k * this.K[ni - 1][mi - 1][pi - 1];
    }
}

