/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Gamma;
import Catalano.Statistics.Distributions.IDistribution;

public class WeibullDistribution
implements IDistribution {
    private double a;
    private double b;

    public WeibullDistribution(double shape, double scale) {
        this.a = shape;
        this.b = scale;
    }

    @Override
    public double Mean() {
        return this.b * Gamma.Function(1.0 + 1.0 / this.a);
    }

    @Override
    public double Variance() {
        return this.b * this.b * Gamma.Function(1.0 + 2.0 / this.a) - this.Mean() * this.Mean();
    }

    @Override
    public double Entropy() {
        return 0.5772156649015329 * (1.0 - 1.0 / this.a) + Math.log(this.b / this.a) + 1.0;
    }

    @Override
    public double DistributionFunction(double x) {
        if (x > 0.0) {
            return 1.0 - Math.exp(-Math.pow(x / this.b, this.a));
        }
        if (x == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        if (x > 0.0) {
            return this.a / this.b * Math.pow(x / this.b, this.a - 1.0) * Math.exp(-Math.pow(x / this.b, this.a));
        }
        return 0.0;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        if (x >= 0.0) {
            return Math.log(this.a / this.b) + (this.a - 1.0) * Math.log(x / this.b) - Math.pow(x / this.b, this.a);
        }
        return Double.NEGATIVE_INFINITY;
    }
}

