/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Matrix;
import Catalano.Math.Special;
import Catalano.Statistics.Distributions.IDistribution;

public class KolmogorovSmirnovDistribution
implements IDistribution {
    private static int eV;
    private int numberOfSamples;

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public KolmogorovSmirnovDistribution(int samples) {
        this.numberOfSamples = samples;
    }

    @Override
    public double Mean() {
        return 0.8687311606361592 / Math.sqrt(this.numberOfSamples);
    }

    @Override
    public double Variance() {
        return (0.8224670334241132 - this.Mean() * this.Mean()) / (double)this.numberOfSamples;
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double DistributionFunction(double x) {
        return KolmogorovSmirnovDistribution.CumulativeFunction(this.numberOfSamples, x);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public double ComplementaryDistributionFunction(double x) {
        return KolmogorovSmirnovDistribution.ComplementaryDistributionFunction(this.numberOfSamples, x);
    }

    public double OneSideDistributionFunction(double x) {
        return KolmogorovSmirnovDistribution.OneSideUpperTail(this.numberOfSamples, x);
    }

    public static double CumulativeFunction(int n, double x) {
        double nxx = (double)n * x * x;
        if (x >= 1.0 || nxx >= 18.0) {
            return 1.0;
        }
        if (x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0 * x - 1.0;
        }
        if (x <= 1.0 / (double)n) {
            return n <= 20 ? Special.Factorial(n) * Math.pow(2.0 * x - 1.0 / (double)n, n) : Math.exp(Special.LogFactorial(n) + (double)n * Math.log(2.0 * x - 1.0 / (double)n));
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 1.0 - 2.0 * Math.pow(1.0 - x, n);
        }
        if (n <= 140) {
            if (nxx < 0.754693) {
                return KolmogorovSmirnovDistribution.Durbin(n, x);
            }
            if (nxx < 4.0) {
                return KolmogorovSmirnovDistribution.Pomeranz(n, x);
            }
            return 1.0 - KolmogorovSmirnovDistribution.ComplementaryDistributionFunction(n, x);
        }
        if (n <= 100000) {
            if ((double)n * nxx * x <= 1.96) {
                return KolmogorovSmirnovDistribution.Durbin(n, x);
            }
            return KolmogorovSmirnovDistribution.PelzGood(n, x);
        }
        return KolmogorovSmirnovDistribution.PelzGood(n, x);
    }

    public static double ComplementaryDistributionFunction(int n, double x) {
        double nxx = (double)n * x * x;
        if (x >= 1.0 || nxx >= 370.0) {
            return 0.0;
        }
        if (x <= 0.5 / (double)n || nxx <= 0.0274) {
            return 1.0;
        }
        if (n == 1) {
            return 2.0 - 2.0 * x;
        }
        if (x <= 1.0 / (double)n) {
            return n <= 20 ? 1.0 - Special.Factorial(n) * Math.pow(2.0 * x - 1.0 / (double)n, n) : 1.0 - Math.exp(Special.LogFactorial(n) + (double)n * Math.log(2.0 * x - 1.0 / (double)n));
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 2.0 * Math.pow(1.0 - x, n);
        }
        if (n <= 140) {
            if (nxx >= 4.0) {
                return 2.0 * KolmogorovSmirnovDistribution.OneSideUpperTail(n, x);
            }
            return 1.0 - KolmogorovSmirnovDistribution.CumulativeFunction(n, x);
        }
        if (nxx >= 2.2) {
            return 2.0 * KolmogorovSmirnovDistribution.OneSideUpperTail(n, x);
        }
        return 1.0 - KolmogorovSmirnovDistribution.CumulativeFunction(n, x);
    }

    public static double PelzGood(int n, double x) {
        double kk;
        double h;
        double term;
        int maxTerms = 20;
        double eps = 1.0E-10;
        double PI2 = Math.PI * Math.PI;
        double PI4 = 97.40909103400243;
        double sqrtN = Math.sqrt(n);
        double z = sqrtN * x;
        double z2 = z * z;
        double z3 = z2 * z;
        double z4 = z2 * z2;
        double z5 = z4 * z;
        double z6 = z4 * z2;
        double z7 = z4 * z3;
        double z8 = z4 * z4;
        double z10 = z8 * z2;
        double pz = -9.869604401089358 / (2.0 * z2);
        double k0 = 0.0;
        for (int k = 0; k <= 20 && !((term = Math.exp((h = (double)k + 0.5) * h * pz)) <= 1.0E-10 * (k0 += term)); ++k) {
        }
        double k1 = 0.0;
        for (int k = 0; k <= 20; ++k) {
            double hh = ((double)k + 0.5) * ((double)k + 0.5);
            term = (Math.PI * Math.PI * hh - z2) * Math.exp(hh * pz);
            if (Math.abs(term) <= 1.0E-10 * Math.abs(k1 += term)) break;
        }
        double k2a = 0.0;
        for (int k = 0; k <= 20; ++k) {
            double hh = ((double)k + 0.5) * ((double)k + 0.5);
            term = (6.0 * z6 + 2.0 * z4 + Math.PI * Math.PI * (2.0 * z4 - 5.0 * z2) * hh + 97.40909103400243 * (1.0 - 2.0 * z2) * hh * hh) * Math.exp(hh * pz);
            if (Math.abs(term) <= 1.0E-10 * Math.abs(k2a += term)) break;
        }
        double k2b = 0.0;
        for (int k = 1; k <= 20 && !((term = Math.PI * Math.PI * (kk = (double)(k * k)) * Math.exp(kk * pz)) <= 1.0E-10 * (k2b += term)); ++k) {
        }
        double k3a = 0.0;
        for (int k = 0; k <= 20; ++k) {
            double hh = ((double)k + 0.5) * ((double)k + 0.5);
            term = (-30.0 * z6 - 90.0 * z8 + Math.PI * Math.PI * (135.0 * z4 - 96.0 * z6) * hh + 97.40909103400243 * (212.0 * z4 - 60.0 * z2) * hh * hh + 961.3891935753043 * hh * hh * hh * (5.0 - 30.0 * z2)) * Math.exp(hh * pz);
            if (Math.abs(term) <= 1.0E-10 * Math.abs(k3a += term)) break;
        }
        double k3b = 0.0;
        for (int k = 1; k <= 20; ++k) {
            double kk2 = k * k;
            term = (29.608813203268074 * kk2 * z2 - 97.40909103400243 * kk2 * kk2) * Math.exp(kk2 * pz);
            if (Math.abs(term) <= 1.0E-10 * Math.abs(k3b += term)) break;
        }
        double sum = k0 * (2.5066282746310007 / z) + k1 * (1.2533141373155003 / (sqrtN * 3.0 * z4)) + k2a * (1.2533141373155003 / ((double)n * 36.0 * z7)) - k2b * (1.2533141373155003 / ((double)n * 18.0 * z3)) + k3a * (1.2533141373155003 / ((double)n * sqrtN * 3240.0 * z10)) + k3b * (1.2533141373155003 / ((double)n * sqrtN * 108.0 * z6));
        return sum;
    }

    public static double OneSideUpperTail(int n, double x) {
        double t;
        double term;
        double q;
        int j;
        double logBinomial;
        if (n > 200000) {
            double t2 = (double)(6 * n) * x + 1.0;
            double z = t2 * t2 / (double)(18 * n);
            double v = (1.0 - (2.0 * z * z - 4.0 * z - 1.0) / (double)(18 * n)) * Math.exp(-z);
            if (v <= 0.0) {
                return 0.0;
            }
            if (v >= 1.0) {
                return 1.0;
            }
            return 1.0 * v;
        }
        int jmax = (int)((double)n * (1.0 - x));
        if (1.0 - x - (double)jmax / (double)n <= 0.0) {
            --jmax;
        }
        int jdiv = n > 3000 ? 2 : 3;
        int jstart = jmax / jdiv + 1;
        double LOGJMAX = logBinomial = Special.LogBinomial(n, jstart);
        double EPSILON = 1.0E-12;
        double sum = 0.0;
        for (j = jstart; j <= jmax; ++j) {
            q = (double)j / (double)n + x;
            term = logBinomial + (double)(j - 1) * Math.log(q) + (double)(n - j) * Special.Log1p(-q);
            t = Math.exp(term);
            logBinomial += Math.log((double)(n - j) / (double)(j + 1));
            if (t <= (sum += t) * EPSILON) break;
        }
        jstart = jmax / jdiv;
        logBinomial = LOGJMAX + Math.log((double)(jstart + 1) / (double)(n - jstart));
        for (j = jstart; j > 0; --j) {
            q = (double)j / (double)n + x;
            term = logBinomial + (double)(j - 1) * Math.log(q) + (double)(n - j) * Special.Log1p(-q);
            t = Math.exp(term);
            logBinomial += Math.log((double)j / (double)(n - j + 1));
            if (t <= (sum += t) * EPSILON) break;
        }
        return sum * x + Math.exp((double)n * Special.Log1p(-x));
    }

    public static double Pomeranz(int n, double x) {
        double sum;
        double w;
        double EPS = 1.0E-15;
        int ENO = 350;
        double RENO = Math.pow(2.0, ENO);
        double t = (double)n * x;
        double[] A = new double[2 * n + 3];
        double[] floors = new double[2 * n + 3];
        double[] ceilings = new double[2 * n + 3];
        double[][] V = new double[2][];
        for (int j = 0; j < V.length; ++j) {
            V[j] = new double[n + 2];
        }
        double[][] H = new double[4][];
        for (int j = 0; j < H.length; ++j) {
            H[j] = new double[n + 2];
        }
        double z = KolmogorovSmirnovDistribution.computeLimits(t, floors, ceilings);
        KolmogorovSmirnovDistribution.computeA(n, A, z);
        KolmogorovSmirnovDistribution.computeH(n, A, H);
        V[1][1] = RENO;
        int renormalizations = 1;
        int r1 = 0;
        int r2 = 1;
        for (int i = 2; i <= 2 * n + 2; ++i) {
            int j;
            int klow;
            int jup;
            int jlow = (int)(2.0 + floors[i]);
            if (jlow < 1) {
                jlow = 1;
            }
            if ((jup = (int)ceilings[i]) > n + 1) {
                jup = n + 1;
            }
            if ((klow = (int)(2.0 + floors[i - 1])) < 1) {
                klow = 1;
            }
            int kup0 = (int)ceilings[i - 1];
            w = (A[i] - A[i - 1]) / (double)n;
            int s = -1;
            for (j = 0; j < 4; ++j) {
                if (!(Math.abs(w - H[j][1]) <= EPS)) continue;
                s = j;
                break;
            }
            double minsum = RENO;
            r1 = r1 + 1 & 1;
            r2 = r2 + 1 & 1;
            for (j = jlow; j <= jup; ++j) {
                int kup = kup0;
                if (kup > j) {
                    kup = j;
                }
                sum = 0.0;
                for (int k = kup; k >= klow; --k) {
                    sum += V[r1][k] * H[s][j - k];
                }
                V[r2][j] = sum;
                if (!(sum < minsum)) continue;
                minsum = sum;
            }
            if (!(minsum < 1.0E-280)) continue;
            j = jlow;
            while (j <= jup) {
                double[] dArray = V[r2];
                int n2 = j++;
                dArray[n2] = dArray[n2] * RENO;
            }
            ++renormalizations;
        }
        sum = V[r2][n + 1];
        w = Special.LogFactorial(n) - (double)(renormalizations * ENO) * 0.6931471805599453 + Math.log(sum);
        if (w >= 0.0) {
            return 1.0;
        }
        return Math.exp(w);
    }

    public static double Durbin(int n, double d) {
        int j;
        int i;
        int k = (int)((double)n * d) + 1;
        int m = 2 * k - 1;
        double h = (double)k - (double)n * d;
        double[][] H = new double[m][m];
        double[][] Q = new double[m][m];
        double[][] B = new double[m][m];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 < 0) continue;
                H[i][j] = 1.0;
            }
        }
        for (i = 0; i < m; ++i) {
            double[] dArray = H[i];
            dArray[0] = dArray[0] - Math.pow(h, i + 1);
            double[] dArray2 = H[m - 1];
            int n2 = i;
            dArray2[n2] = dArray2[n2] - Math.pow(h, m - i);
        }
        double[] dArray = H[m - 1];
        dArray[0] = dArray[0] + (2.0 * h - 1.0 > 0.0 ? Math.pow(2.0 * h - 1.0, m) : 0.0);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 1; g <= i - j + 1; ++g) {
                    double[] dArray3 = H[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] / (double)g;
                }
            }
        }
        int pQ = 0;
        KolmogorovSmirnovDistribution.matrixPower(H, 0, Q, m, n, B);
        double s = Q[k - 1][k - 1];
        for (int i2 = 1; i2 <= n; ++i2) {
            if (!((s *= (double)i2 / (double)n) < 1.0E-140)) continue;
            s *= 1.0E140;
            pQ -= 140;
        }
        return s * Math.pow(10.0, pQ);
    }

    private static void matrixPower(double[][] A, int eA, double[][] V, int m, int n, double[][] B) {
        int j;
        int i;
        if (n == 1) {
            for (int i2 = 0; i2 < m; ++i2) {
                for (int j2 = 0; j2 < m; ++j2) {
                    V[i2][j2] = A[i2][j2];
                }
            }
            eV = eA;
            return;
        }
        KolmogorovSmirnovDistribution.matrixPower(A, eA, V, m, n / 2, B);
        B = Matrix.Multiply(V, B);
        int eB = 2 * eV;
        if (B[m / 2][m / 2] > 1.0E140) {
            for (i = 0; i < m; ++i) {
                j = 0;
                while (j < m) {
                    double[] dArray = B[i];
                    int n2 = j++;
                    dArray[n2] = dArray[n2] * 1.0E-140;
                }
            }
            eB += 140;
        }
        if (n % 2 == 0) {
            for (i = 0; i < m; ++i) {
                for (j = 0; j < m; ++j) {
                    V[i][j] = B[i][j];
                }
            }
            eV = eB;
        } else {
            V = Matrix.Multiply(A, B);
            eV = eA + eB;
        }
        if (V[m / 2][m / 2] > 1.0E140) {
            for (i = 0; i < m; ++i) {
                j = 0;
                while (j < m) {
                    double[] dArray = V[i];
                    int n3 = j++;
                    dArray[n3] = dArray[n3] * 1.0E-140;
                }
            }
            eV += 140;
        }
    }

    private static double computeLimits(double t, double[] floors, double[] ceilings) {
        double floor = Math.floor(t);
        double ceiling = Math.ceil(t);
        double z = t - floor;
        double w = ceiling - t;
        if (z > 0.5) {
            int i;
            for (i = 1; i < floors.length; i += 2) {
                floors[i] = (double)(i / 2 - 1) - floor;
            }
            for (i = 2; i < floors.length; i += 2) {
                floors[i] = (double)(i / 2 - 2) - floor;
            }
            for (i = 1; i < ceilings.length; i += 2) {
                ceilings[i] = (double)(i / 2 + 1) + floor;
            }
            for (i = 2; i < ceilings.length; i += 2) {
                ceilings[i] = (double)(i / 2) + floor;
            }
        } else if (z > 0.0) {
            int i;
            ceilings[1] = 1.0 + floor;
            for (i = 1; i < floors.length; ++i) {
                floors[i] = (double)(i / 2 - 1) - floor;
            }
            for (i = 2; i < ceilings.length; ++i) {
                ceilings[i] = (double)(i / 2) + floor;
            }
        } else {
            int i;
            for (i = 1; i < floors.length; i += 2) {
                floors[i] = (double)(i / 2) - floor;
            }
            for (i = 2; i < floors.length; i += 2) {
                floors[i] = (double)(i / 2 - 1) - floor;
            }
            for (i = 1; i < ceilings.length; i += 2) {
                ceilings[i] = (double)(i / 2) + floor;
            }
            for (i = 2; i < ceilings.length; i += 2) {
                ceilings[i] = (double)(i / 2 - 1) + floor;
            }
        }
        if (w < z) {
            z = w;
        }
        return z;
    }

    private static void computeA(int n, double[] A, double z) {
        A[0] = 0.0;
        A[1] = 0.0;
        A[2] = z;
        A[3] = 1.0 - z;
        for (int i = 4; i < A.length - 1; ++i) {
            A[i] = A[i - 2] + 1.0;
        }
        A[A.length - 1] = n;
    }

    private static double computeH(int n, double[] A, double[][] H) {
        int j;
        H[0][0] = 1.0;
        double w = 2.0 * A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[0][j] = w * H[0][j - 1] / (double)j;
        }
        H[1][0] = 1.0;
        w = (1.0 - 2.0 * A[2]) / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[1][j] = w * H[1][j - 1] / (double)j;
        }
        H[2][0] = 1.0;
        w = A[2] / (double)n;
        for (j = 1; j <= n + 1; ++j) {
            H[2][j] = w * H[2][j - 1] / (double)j;
        }
        H[3][0] = 1.0;
        for (j = 1; j <= n + 1; ++j) {
            H[3][j] = 0.0;
        }
        return w;
    }
}

