/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Gamma;
import Catalano.Statistics.Distributions.IDistribution;

public class GammaDistribution
implements IDistribution {
    private double scale;
    private double shape;
    private double constant;
    private double lnconstant;

    public GammaDistribution(double scale, double shape) {
        this.scale = scale;
        this.shape = shape;
        this.constant = 1.0 / (Math.pow(scale, shape) * Gamma.Function(shape));
        this.lnconstant = -(shape * Math.log(scale) + Gamma.Log(shape));
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double Mean() {
        return this.shape * this.scale;
    }

    @Override
    public double Variance() {
        return this.shape * this.scale * this.scale;
    }

    public double Median() {
        return Double.NaN;
    }

    @Override
    public double Entropy() {
        return this.shape + Math.log(this.scale) + Gamma.Log(this.shape) + (1.0 - this.shape) * Gamma.Digamma(this.shape);
    }

    @Override
    public double DistributionFunction(double x) {
        return Gamma.LowerIncomplete(this.shape, x / this.scale);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        return this.constant * Math.pow(x, this.shape - 1.0) * Math.exp(-x / this.scale);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        return this.lnconstant + (this.shape - 1.0) * Math.log(x) - x / this.scale;
    }
}

