/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Beta;
import Catalano.Math.Special;
import Catalano.Statistics.Distributions.IDiscreteDistribution;

public class BinomialDistribution
implements IDiscreteDistribution {
    private int numberOfTrials;
    private double probability;

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbability() {
        return this.probability;
    }

    public BinomialDistribution(int trials) {
        this(trials, 0.0);
    }

    public BinomialDistribution(int trials, double probability) {
        if (trials <= 0) {
            throw new IllegalArgumentException("The number of trials should be greater than zero.");
        }
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("A probability must be between 0 and 1.");
        }
        this.numberOfTrials = trials;
        this.probability = probability;
    }

    @Override
    public double Mean() {
        return (double)this.numberOfTrials * this.probability;
    }

    @Override
    public double Variance() {
        return (double)this.numberOfTrials * this.probability * (1.0 - this.probability);
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double DistributionFunction(int k) {
        return Beta.Incomplete(this.numberOfTrials - k, k + 1, 1.0 - this.probability);
    }

    @Override
    public double ProbabilityMassFunction(int k) {
        if (k < 0 || k > this.numberOfTrials) {
            return 0.0;
        }
        return Special.Binomial(this.numberOfTrials, k) * Math.pow(this.probability, k) * Math.pow(1.0 - this.probability, this.numberOfTrials - k);
    }

    @Override
    public double LogProbabilityMassFunction(int k) {
        if (k < 0 || k > this.numberOfTrials) {
            return Double.NEGATIVE_INFINITY;
        }
        return Special.LogBinomial(this.numberOfTrials, k) + (double)k * Math.log(this.probability) + (double)(this.numberOfTrials - k) * Math.log(1.0 - this.probability);
    }
}

