/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDiscreteDistribution;

public class BernoulliDistribution
implements IDiscreteDistribution {
    private double probability;
    private double complement;
    private Double entropy;

    public BernoulliDistribution(double mean) {
        this.probability = mean;
        this.complement = 1.0 - mean;
        this.entropy = null;
    }

    @Override
    public double Mean() {
        return this.probability;
    }

    @Override
    public double Variance() {
        return this.probability * this.complement;
    }

    @Override
    public double Entropy() {
        if (this.entropy == null) {
            this.entropy = -this.probability * Math.log(this.probability) - this.complement * Math.log(this.complement);
        }
        return this.entropy;
    }

    @Override
    public double DistributionFunction(int k) {
        if (k < 0) {
            return 0.0;
        }
        if (k >= 1) {
            return 1.0;
        }
        return this.complement;
    }

    @Override
    public double ProbabilityMassFunction(int k) {
        if (k == 1) {
            return this.probability;
        }
        if (k == 0) {
            return this.complement;
        }
        return 0.0;
    }

    @Override
    public double LogProbabilityMassFunction(int k) {
        if (k == 1) {
            return Math.log(this.probability);
        }
        if (k == 0) {
            return Math.log(this.complement);
        }
        return Double.NEGATIVE_INFINITY;
    }
}

