/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Core.ArraysUtil;
import Catalano.Statistics.Tools;

public final class Correlations {
    private Correlations() {
    }

    public static double VectorInnerProduct(double[] p, double[] q) {
        double product = 0.0;
        for (int i = 0; i < p.length; ++i) {
            product += p[i] * q[i];
        }
        return product;
    }

    public static double Tanimoto(double[] p, double[] q) {
        double product = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < p.length; ++i) {
            product += p[i] * q[i];
            x += p[i] * p[i];
            y += q[i] * q[i];
        }
        return product / (x + y - product);
    }

    public static double PearsonCorrelation(double[] x, double[] y) {
        double meanX = Tools.Mean(x);
        double meanY = Tools.Mean(y);
        return Correlations.PearsonCorrelation(x, y, meanX, meanY);
    }

    public static double PearsonCorrelation(double[] x, double[] y, double meanX, double meanY) {
        double sumNum = 0.0;
        double sumDenX = 0.0;
        double sumDenY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sumNum += (x[i] - meanX) * (y[i] - meanY);
            sumDenX += Math.pow(x[i] - meanX, 2.0);
            sumDenY += Math.pow(y[i] - meanY, 2.0);
        }
        double sumDen = Math.sqrt(sumDenX * sumDenY);
        return sumNum / sumDen;
    }

    public static double SpearmanCorrelation(double[] x, double[] y) {
        int[] r1 = ArraysUtil.Argsort(x, true);
        int[] r2 = ArraysUtil.Argsort(y, true);
        double diff = 0.0;
        for (int i = 0; i < r1.length; ++i) {
            diff += (double)(r1[i] - r2[i]);
        }
        double den = (double)r1.length * (Math.pow(r1.length, 2.0) - 1.0);
        return 1.0 - (diff *= 6.0) / den;
    }
}

