/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Analysis;

import Catalano.Math.Decompositions.SingularValueDecomposition;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class PrincipalComponentAnalysis {
    private double[][] matrix;
    private double[] meanColumn;
    private double[] stdColumn;
    private double[] singularValues;
    private double[][] eigenVectors;
    private double[] eigenValues;
    private double[][] result;
    private AnalysisMethod method;

    public double[][] getResult() {
        return this.result;
    }

    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }

    public PrincipalComponentAnalysis(double[][] matrix) {
        this(matrix, AnalysisMethod.Center);
    }

    public PrincipalComponentAnalysis(double[][] matrix, AnalysisMethod method) {
        this.matrix = matrix;
        this.method = method;
    }

    public void Compute() {
        this.meanColumn = new double[this.matrix[0].length];
        this.stdColumn = new double[this.matrix[0].length];
        int cols = this.matrix[0].length;
        for (int i = 0; i < cols; ++i) {
            double[] col = Matrix.getColumn(this.matrix, i);
            this.meanColumn[i] = Tools.Mean(col);
            this.stdColumn[i] = Tools.StandartDeviation(col, this.meanColumn[i]);
        }
        double[][] m = this.Center(this.matrix, this.meanColumn);
        if (this.method == AnalysisMethod.Standartize) {
            for (int i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[0].length; ++j) {
                    double[] dArray = m[i];
                    int n = j;
                    dArray[n] = dArray[n] / this.stdColumn[j];
                }
            }
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(m);
        this.singularValues = svd.getSingularValues();
        this.eigenVectors = svd.getV();
        this.result = Matrix.MultiplyByDiagonal(svd.getU(), this.singularValues);
        this.eigenValues = new double[this.singularValues.length];
        for (int i = 0; i < this.singularValues.length; ++i) {
            this.eigenValues[i] = this.singularValues[i] * this.singularValues[i] / (double)(this.matrix.length - 1);
        }
        this.CreateComponents();
    }

    private void CreateComponents() {
    }

    private double[][] Center(double[][] matrix, double[] means) {
        double[][] m = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = matrix[i][j] - means[j];
            }
        }
        return m;
    }

    public static enum AnalysisMethod {
        Standartize,
        Center;

    }
}

