/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Signal;

import Catalano.Math.ComplexNumber;

public class Convolution {
    private Mode mode = Mode.Valid;

    public Convolution() {
    }

    public Convolution(Mode mode) {
        this.mode = mode;
    }

    public double[][] Process(double[][] signal, double[][] kernel) {
        double[][] result = null;
        switch (this.mode) {
            case Same: {
                int width = signal[0].length;
                int height = signal[1].length;
                int lineI = (kernel.length - 1) / 2;
                int lineJ = (kernel[0].length - 1) / 2;
                result = new double[height][width];
                for (int i = 0; i < height; ++i) {
                    double conv = 0.0;
                    for (int j = 0; j < width; ++j) {
                        for (int k = 0; k < kernel.length; ++k) {
                            int Xline = i + (k - lineI);
                            for (int l = 0; l < kernel[0].length; ++l) {
                                int Yline = j + (l - lineJ);
                                if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                conv += result[Xline][Yline] * kernel[kernel.length - k - 1][kernel[0].length - l - 1];
                            }
                        }
                        result[i][j] = conv;
                    }
                }
                break;
            }
            case Valid: {
                int width = signal[0].length - kernel[0].length + 1;
                int height = signal.length - kernel.length + 1;
                result = new double[height][width];
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        double conv = 0.0;
                        for (int k = 0; k < kernel.length; ++k) {
                            for (int l = 0; l < kernel[0].length; ++l) {
                                conv += signal[i + k][j + l] * kernel[kernel.length - k - 1][kernel[0].length - l - 1];
                            }
                        }
                        result[i][j] = conv;
                    }
                }
                break;
            }
        }
        return result;
    }

    public ComplexNumber[][] Process(ComplexNumber[][] signal, ComplexNumber[][] kernel) {
        ComplexNumber[][] result = null;
        switch (this.mode) {
            case Same: {
                int width = signal[0].length;
                int height = signal[1].length;
                int lineI = (kernel.length - 1) / 2;
                int lineJ = (kernel[0].length - 1) / 2;
                result = new ComplexNumber[height][width];
                for (int i = 0; i < height; ++i) {
                    ComplexNumber conv = new ComplexNumber(0.0, 0.0);
                    for (int j = 0; j < width; ++j) {
                        for (int k = 0; k < kernel.length; ++k) {
                            int Xline = i + (k - lineI);
                            for (int l = 0; l < kernel[0].length; ++l) {
                                int Yline = j + (l - lineJ);
                                if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                                conv = ComplexNumber.Add(conv, ComplexNumber.Multiply(result[Xline][Yline], kernel[kernel.length - k - 1][kernel[0].length - l - 1]));
                            }
                        }
                        result[i][j] = conv;
                    }
                }
                break;
            }
            case Valid: {
                int width = signal[0].length - kernel[0].length + 1;
                int height = signal.length - kernel.length + 1;
                result = new ComplexNumber[height][width];
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        ComplexNumber conv = new ComplexNumber(0.0, 0.0);
                        for (int k = 0; k < kernel.length; ++k) {
                            for (int l = 0; l < kernel[0].length; ++l) {
                                conv = ComplexNumber.Add(conv, ComplexNumber.Multiply(result[i + k][j + l], kernel[kernel.length - k - 1][kernel[0].length - l - 1]));
                            }
                        }
                        result[i][j] = conv;
                    }
                }
                break;
            }
        }
        return result;
    }

    public static enum Mode {
        Same,
        Valid;

    }
}

