/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Neuro.Classifier;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import Catalano.Neuro.ActivationFunction.IActivationFunction;
import Catalano.Neuro.ActivationFunction.SigmoidFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class ExtremeLearningMachine
implements IClassifier,
Serializable {
    private int nHiddenNodes;
    private IActivationFunction function;
    private double c = 1.0;
    private long seed = 0L;
    private double[] bias;
    private double[][] inputWeight;
    private double[][] outputWeight;

    public int getNumberOfHiddenNodes() {
        return this.nHiddenNodes;
    }

    public void setNumberOfHiddenNodes(int nHiddenNodes) {
        this.nHiddenNodes = nHiddenNodes;
    }

    public double getRegulazationFactor() {
        return this.c;
    }

    public void setRegularizationFactor(double c) {
        this.c = Math.max(1.0, c);
    }

    public double[] getBias() {
        return this.bias;
    }

    public void setBias(double[] bias) {
        this.bias = bias;
    }

    public double[][] getInputWeight() {
        return this.inputWeight;
    }

    public void setInputWeight(double[][] inputWeight) {
        this.inputWeight = inputWeight;
    }

    public double[][] getOutputWeight() {
        return this.outputWeight;
    }

    public void setOutputWeight(double[][] outputWeight) {
        this.outputWeight = outputWeight;
    }

    public IActivationFunction getFunction() {
        return this.function;
    }

    public void setFunction(IActivationFunction function) {
        this.function = function;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public ExtremeLearningMachine() {
        this(20);
    }

    public ExtremeLearningMachine(int nHiddenNodes) {
        this(nHiddenNodes, 100.0);
    }

    public ExtremeLearningMachine(int nHiddenNodes, double c) {
        this(nHiddenNodes, c, new SigmoidFunction());
    }

    public ExtremeLearningMachine(int nHiddenNodes, double c, IActivationFunction function) {
        this(nHiddenNodes, c, function, 0L);
    }

    public ExtremeLearningMachine(int nHiddenNodes, double c, IActivationFunction function, long seed) {
        this.nHiddenNodes = nHiddenNodes;
        this.c = c;
        this.function = function;
        this.seed = seed;
    }

    @Override
    public void Learn(DatasetClassification dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, int[] output) {
        int i;
        int j;
        int i2;
        Random r = new Random();
        if (this.seed != 0L) {
            r.setSeed(this.seed);
        }
        double[][] _input = Matrix.Transpose(input);
        int nOutputNeurons = Matrix.Max(output) + 1;
        int[] uniques = Tools.Unique(output);
        Arrays.sort(output);
        double[][] t = new double[nOutputNeurons][input.length];
        for (i2 = 0; i2 < t.length; ++i2) {
            int l = uniques[i2];
            for (j = 0; j < t[0].length; ++j) {
                t[i2][j] = output[j] == l ? 1.0 : -1.0;
            }
        }
        if (this.inputWeight == null) {
            this.inputWeight = new double[this.nHiddenNodes][_input.length];
            for (i2 = 0; i2 < this.inputWeight.length; ++i2) {
                for (int j2 = 0; j2 < this.inputWeight[0].length; ++j2) {
                    this.inputWeight[i2][j2] = r.nextDouble() * 2.0 - 1.0;
                }
            }
        }
        if (this.bias == null) {
            this.bias = new double[this.nHiddenNodes];
            for (i2 = 0; i2 < this.bias.length; ++i2) {
                this.bias[i2] = r.nextDouble();
            }
        }
        double[][] h = Matrix.Multiply(this.inputWeight, _input);
        for (i = 0; i < h.length; ++i) {
            j = 0;
            while (j < h[0].length) {
                double[] dArray = h[i];
                int n = j++;
                dArray[n] = dArray[n] + this.bias[i];
            }
        }
        for (i = 0; i < h.length; ++i) {
            for (j = 0; j < h[0].length; ++j) {
                h[i][j] = this.function.Function(h[i][j]);
            }
        }
        double[][] b = Matrix.MultiplyByTranspose(h);
        int i3 = 0;
        while (i3 < b.length) {
            double[] dArray = b[i3];
            int n = i3++;
            dArray[n] = dArray[n] + 1.0 / this.c;
        }
        this.outputWeight = Matrix.Multiply(Matrix.Inverse(b), h);
        this.outputWeight = Matrix.Multiply(this.outputWeight, Matrix.Transpose(t));
    }

    @Override
    public int Predict(double[] feature) {
        double[] temp = Matrix.MultiplyByTranspose(this.inputWeight, feature);
        Matrix.Add(temp, this.bias);
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.function.Function(temp[i]);
        }
        double[] r = Matrix.Multiply(temp, this.outputWeight);
        int v = Matrix.MaxIndex(r);
        return v;
    }

    @Override
    public IClassifier clone() {
        try {
            return (IClassifier)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }
}

