/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Wavelets;

import Catalano.Math.Wavelets.IWavelet;

public class Haar
implements IWavelet {
    private static final double w0 = 0.5;
    private static final double w1 = -0.5;
    private static final double s0 = 0.5;
    private static final double s1 = 0.5;
    private int levels = 2;

    public Haar(int levels) {
        this.levels = levels;
    }

    @Override
    public void Forward(double[] data) {
        int i;
        double[] temp = new double[data.length];
        int h = data.length >> 1;
        for (i = 0; i < h; ++i) {
            int k = i << 1;
            temp[i] = data[k] * 0.5 + data[k + 1] * 0.5;
            temp[i + h] = data[k] * 0.5 + data[k + 1] * -0.5;
        }
        for (i = 0; i < data.length; ++i) {
            data[i] = temp[i];
        }
    }

    @Override
    public void Forward(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[] row = new double[cols];
        double[] col = new double[rows];
        for (int k = 0; k < this.levels; ++k) {
            for (int i = 0; i < rows; ++i) {
                int j;
                for (j = 0; j < row.length; ++j) {
                    row[j] = data[i][j];
                }
                this.Forward(row);
                for (j = 0; j < row.length; ++j) {
                    data[i][j] = row[j];
                }
            }
            for (int j = 0; j < cols; ++j) {
                int i;
                for (i = 0; i < col.length; ++i) {
                    col[i] = data[i][j];
                }
                this.Forward(col);
                for (i = 0; i < col.length; ++i) {
                    data[i][j] = col[i];
                }
            }
        }
    }

    @Override
    public void Backward(double[] data) {
        int i;
        double[] temp = new double[data.length];
        int h = data.length >> 1;
        for (i = 0; i < h; ++i) {
            int k = i << 1;
            temp[k] = (data[i] * 0.5 + data[i + h] * 0.5) / 0.5;
            temp[k + 1] = (data[i] * 0.5 + data[i + h] * -0.5) / 0.5;
        }
        for (i = 0; i < data.length; ++i) {
            data[i] = temp[i];
        }
    }

    @Override
    public void Backward(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[] row = new double[cols];
        double[] col = new double[rows];
        for (int l = 0; l < this.levels; ++l) {
            for (int j = 0; j < cols; ++j) {
                int i;
                for (i = 0; i < row.length; ++i) {
                    col[i] = data[i][j];
                }
                this.Backward(col);
                for (i = 0; i < col.length; ++i) {
                    data[i][j] = col[i];
                }
            }
            for (int i = 0; i < rows; ++i) {
                int j;
                for (j = 0; j < row.length; ++j) {
                    row[j] = data[i][j];
                }
                this.Backward(row);
                for (j = 0; j < row.length; ++j) {
                    data[i][j] = row[j];
                }
            }
        }
    }
}

