/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Transforms;

import Catalano.Math.ComplexNumber;

public class FourierTransform {
    public static void DFT(ComplexNumber[] data, Direction direction) {
        int i;
        int n = data.length;
        ComplexNumber[] c = new ComplexNumber[n];
        for (i = 0; i < n; ++i) {
            c[i] = new ComplexNumber(0.0, 0.0);
            double sumRe = 0.0;
            double sumIm = 0.0;
            double phim = Math.PI * 2 * (double)i / (double)n;
            for (int j = 0; j < n; ++j) {
                double gRe = data[j].real;
                double gIm = data[j].imaginary;
                double cosw = Math.cos(phim * (double)j);
                double sinw = Math.sin(phim * (double)j);
                if (direction == Direction.Backward) {
                    sinw = -sinw;
                }
                sumRe += gRe * cosw + data[j].imaginary * sinw;
                sumIm += gIm * cosw - data[j].real * sinw;
            }
            c[i] = new ComplexNumber(sumRe, sumIm);
        }
        if (direction == Direction.Backward) {
            for (i = 0; i < c.length; ++i) {
                data[i].real = c[i].real / (double)n;
                data[i].imaginary = c[i].imaginary / (double)n;
            }
        } else {
            for (i = 0; i < c.length; ++i) {
                data[i].real = c[i].real;
                data[i].imaginary = c[i].imaginary;
            }
        }
    }

    public static void DFT2(ComplexNumber[][] data, Direction direction) {
        int j;
        int n = data.length;
        int m = data[0].length;
        ComplexNumber[] row = new ComplexNumber[Math.max(m, n)];
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                row[j] = data[i][j];
            }
            FourierTransform.DFT(row, direction);
            for (j = 0; j < n; ++j) {
                data[i][j] = row[j];
            }
        }
        ComplexNumber[] col = new ComplexNumber[n];
        for (j = 0; j < n; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                col[i] = data[i][j];
            }
            FourierTransform.DFT(col, direction);
            for (i = 0; i < n; ++i) {
                data[i][j] = col[i];
            }
        }
    }

    public static void FFT(ComplexNumber[] data, Direction direction) {
        double[] real = ComplexNumber.getReal(data);
        double[] img = ComplexNumber.getImaginary(data);
        if (direction == Direction.Forward) {
            FourierTransform.FFT(real, img);
        } else {
            FourierTransform.FFT(img, real);
        }
        if (direction == Direction.Forward) {
            for (int i = 0; i < real.length; ++i) {
                data[i] = new ComplexNumber(real[i], img[i]);
            }
        } else {
            int n = real.length;
            for (int i = 0; i < n; ++i) {
                data[i] = new ComplexNumber(real[i] / (double)n, img[i] / (double)n);
            }
        }
    }

    public static void FFT2(ComplexNumber[][] data, Direction direction) {
        int n = data.length;
        int m = data[0].length;
        for (int i = 0; i < n; ++i) {
            ComplexNumber[] row = data[i];
            FourierTransform.FFT(row, direction);
            for (int j = 0; j < m; ++j) {
                data[i][j] = row[j];
            }
        }
        ComplexNumber[] col = new ComplexNumber[n];
        for (int j = 0; j < m; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                col[i] = data[i][j];
            }
            FourierTransform.FFT(col, direction);
            for (i = 0; i < n; ++i) {
                data[i][j] = col[i];
            }
        }
    }

    private static void FFT(double[] real, double[] imag) {
        int n = real.length;
        if (n == 0) {
            return;
        }
        if ((n & n - 1) == 0) {
            FourierTransform.transformRadix2(real, imag);
        } else {
            FourierTransform.transformBluestein(real, imag);
        }
    }

    private static void inverseTransform(double[] real, double[] imag) {
        FourierTransform.FFT(imag, real);
    }

    private static void transformRadix2(double[] real, double[] imag) {
        int i;
        int n = real.length;
        int levels = 31 - Integer.numberOfLeadingZeros(n);
        double[] cosTable = new double[n / 2];
        double[] sinTable = new double[n / 2];
        for (i = 0; i < n / 2; ++i) {
            cosTable[i] = Math.cos(Math.PI * 2 * (double)i / (double)n);
            sinTable[i] = Math.sin(Math.PI * 2 * (double)i / (double)n);
        }
        for (i = 0; i < n; ++i) {
            int j = Integer.reverse(i) >>> 32 - levels;
            if (j <= i) continue;
            double temp = real[i];
            real[i] = real[j];
            real[j] = temp;
            temp = imag[i];
            imag[i] = imag[j];
            imag[j] = temp;
        }
        for (int size = 2; size <= n; size *= 2) {
            int halfsize = size / 2;
            int tablestep = n / size;
            for (int i2 = 0; i2 < n; i2 += size) {
                int j = i2;
                int k = 0;
                while (j < i2 + halfsize) {
                    double tpre = real[j + halfsize] * cosTable[k] + imag[j + halfsize] * sinTable[k];
                    double tpim = -real[j + halfsize] * sinTable[k] + imag[j + halfsize] * cosTable[k];
                    real[j + halfsize] = real[j] - tpre;
                    imag[j + halfsize] = imag[j] - tpim;
                    int n2 = j;
                    real[n2] = real[n2] + tpre;
                    int n3 = j++;
                    imag[n3] = imag[n3] + tpim;
                    k += tablestep;
                }
            }
            if (size == n) break;
        }
    }

    private static void transformBluestein(double[] real, double[] imag) {
        int n = real.length;
        int m = Integer.highestOneBit(n * 2 + 1) << 1;
        double[] cosTable = new double[n];
        double[] sinTable = new double[n];
        for (int i = 0; i < n; ++i) {
            int j = (int)((long)i * (long)i % (long)(n * 2));
            cosTable[i] = Math.cos(Math.PI * (double)j / (double)n);
            sinTable[i] = Math.sin(Math.PI * (double)j / (double)n);
        }
        double[] areal = new double[m];
        double[] aimag = new double[m];
        for (int i = 0; i < n; ++i) {
            areal[i] = real[i] * cosTable[i] + imag[i] * sinTable[i];
            aimag[i] = -real[i] * sinTable[i] + imag[i] * cosTable[i];
        }
        double[] breal = new double[m];
        double[] bimag = new double[m];
        breal[0] = cosTable[0];
        bimag[0] = sinTable[0];
        for (int i = 1; i < n; ++i) {
            double d = cosTable[i];
            breal[m - i] = d;
            breal[i] = d;
            double d2 = sinTable[i];
            bimag[m - i] = d2;
            bimag[i] = d2;
        }
        double[] creal = new double[m];
        double[] cimag = new double[m];
        FourierTransform.convolve(areal, aimag, breal, bimag, creal, cimag);
        for (int i = 0; i < n; ++i) {
            real[i] = creal[i] * cosTable[i] + cimag[i] * sinTable[i];
            imag[i] = -creal[i] * sinTable[i] + cimag[i] * cosTable[i];
        }
    }

    private static void convolve(double[] x, double[] y, double[] out) {
        int n = x.length;
        FourierTransform.convolve(x, new double[n], y, new double[n], out, new double[n]);
    }

    private static void convolve(double[] xreal, double[] ximag, double[] yreal, double[] yimag, double[] outreal, double[] outimag) {
        int i;
        int n = xreal.length;
        FourierTransform.FFT(xreal, ximag);
        FourierTransform.FFT(yreal, yimag);
        for (i = 0; i < n; ++i) {
            double temp = xreal[i] * yreal[i] - ximag[i] * yimag[i];
            ximag[i] = ximag[i] * yreal[i] + xreal[i] * yimag[i];
            xreal[i] = temp;
        }
        FourierTransform.inverseTransform(xreal, ximag);
        for (i = 0; i < n; ++i) {
            outreal[i] = xreal[i] / (double)n;
            outimag[i] = ximag[i] / (double)n;
        }
    }

    public static void FFTShift1D(double[] x, Direction direction) {
        if (x.length == 1) {
            return;
        }
        double[] temp = (double[])x.clone();
        int move = x.length / 2;
        if (direction == Direction.Forward) {
            int i;
            int c = 0;
            for (i = x.length - move; i < x.length; ++i) {
                x[c++] = temp[i];
            }
            for (i = 0; i < x.length - move; ++i) {
                x[c++] = temp[i];
            }
        } else {
            int i;
            int c = 0;
            for (i = move; i < x.length; ++i) {
                x[c++] = temp[i];
            }
            for (i = 0; i < move; ++i) {
                x[c++] = temp[i];
            }
        }
    }

    public static <E> void FFTShift1D(E[] x, Direction direction) {
        if (x.length == 1) {
            return;
        }
        Object[] temp = (Object[])x.clone();
        int move = x.length / 2;
        if (direction == Direction.Forward) {
            int i;
            int c = 0;
            for (i = x.length - move; i < x.length; ++i) {
                x[c++] = temp[i];
            }
            for (i = 0; i < x.length - move; ++i) {
                x[c++] = temp[i];
            }
        } else {
            int i;
            int c = 0;
            for (i = move; i < x.length; ++i) {
                x[c++] = temp[i];
            }
            for (i = 0; i < move; ++i) {
                x[c++] = temp[i];
            }
        }
    }

    public static void FFTShift2D(double[][] x, Direction direction) {
        FourierTransform.FFTShift2D(x, direction, 1);
        FourierTransform.FFTShift2D(x, direction, 2);
    }

    public static void FFTShift2D(double[][] x, Direction direction, int dimension) {
        block16: {
            int i;
            int move;
            int i2;
            double[][] temp;
            block15: {
                temp = new double[x.length][x[0].length];
                for (i2 = 0; i2 < x.length; ++i2) {
                    for (int j = 0; j < x[0].length; ++j) {
                        temp[i2][j] = x[i2][j];
                    }
                }
                if (direction != Direction.Forward) break block15;
                if (dimension == 1) {
                    int j;
                    move = temp.length / 2;
                    for (i = 0; i < move; ++i) {
                        for (j = 0; j < x[0].length; ++j) {
                            x[i][j] = temp[temp.length - move + i][j];
                        }
                    }
                    for (i = move; i < x.length; ++i) {
                        for (j = 0; j < x[0].length; ++j) {
                            x[i][j] = temp[i - move][j];
                        }
                    }
                }
                if (dimension != 2) break block16;
                for (i2 = 0; i2 < x.length; ++i2) {
                    FourierTransform.FFTShift1D(x[i2], Direction.Forward);
                }
                break block16;
            }
            if (dimension == 1) {
                int j;
                move = temp.length / 2;
                for (i = 0; i < x.length - move; ++i) {
                    for (j = 0; j < x[0].length; ++j) {
                        x[i][j] = temp[move + i][j];
                    }
                }
                for (i = 0; i < move; ++i) {
                    for (j = 0; j < x[0].length; ++j) {
                        x[x.length - move + i][j] = temp[i][j];
                    }
                }
            }
            if (dimension == 2) {
                for (i2 = 0; i2 < x.length; ++i2) {
                    FourierTransform.FFTShift1D(x[i2], Direction.Backward);
                }
            }
        }
    }

    public static <E> void FFTShift2D(E[][] x, Direction direction) {
        FourierTransform.FFTShift2D(x, direction, 1);
        FourierTransform.FFTShift2D(x, direction, 2);
    }

    public static <E> void FFTShift2D(E[][] x, Direction direction, int dimension) {
        block16: {
            int i;
            int move;
            int i2;
            Object[][] temp;
            block15: {
                temp = new Object[x.length][x[0].length];
                for (i2 = 0; i2 < x.length; ++i2) {
                    for (int j = 0; j < x[0].length; ++j) {
                        temp[i2][j] = x[i2][j];
                    }
                }
                if (direction != Direction.Forward) break block15;
                if (dimension == 1) {
                    int j;
                    move = temp.length / 2;
                    for (i = 0; i < move; ++i) {
                        for (j = 0; j < x[0].length; ++j) {
                            x[i][j] = temp[temp.length - move + i][j];
                        }
                    }
                    for (i = move; i < x.length; ++i) {
                        for (j = 0; j < x[0].length; ++j) {
                            x[i][j] = temp[i - move][j];
                        }
                    }
                }
                if (dimension != 2) break block16;
                for (i2 = 0; i2 < x.length; ++i2) {
                    FourierTransform.FFTShift1D(x[i2], Direction.Forward);
                }
                break block16;
            }
            if (dimension == 1) {
                int j;
                move = temp.length / 2;
                for (i = 0; i < x.length - move; ++i) {
                    for (j = 0; j < x[0].length; ++j) {
                        x[i][j] = temp[move + i][j];
                    }
                }
                for (i = 0; i < move; ++i) {
                    for (j = 0; j < x[0].length; ++j) {
                        x[x.length - move + i][j] = temp[i][j];
                    }
                }
            }
            if (dimension == 2) {
                for (i2 = 0; i2 < x.length; ++i2) {
                    FourierTransform.FFTShift1D(x[i2], Direction.Backward);
                }
            }
        }
    }

    public static enum Direction {
        Forward,
        Backward;

    }
}

