/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Core.DoubleRange;
import Catalano.Core.FloatRange;
import Catalano.Core.IntRange;
import Catalano.Math.Random.Random;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class Tools {
    private static Random random = new Random();

    public static Random Random() {
        return random;
    }

    public static void SetupGenerator(int seed) {
        random = new Random(seed);
    }

    public static double Square(double x) {
        return x * x;
    }

    public static double Sinc(double x) {
        return Math.sin(Math.PI * x) / (Math.PI * x);
    }

    private Tools() {
    }

    public static float Angle(float x, float y) {
        if (y >= 0.0f) {
            if (x >= 0.0f) {
                return (float)Math.atan(y / x);
            }
            return (float)(Math.PI - Math.atan(-y / x));
        }
        if (x >= 0.0f) {
            return (float)(Math.PI * 2 - Math.atan(-y / x));
        }
        return (float)(Math.PI + Math.atan(y / x));
    }

    public static double Angle(double x, double y) {
        if (y >= 0.0) {
            if (x >= 0.0) {
                return Math.atan(y / x);
            }
            return Math.PI - Math.atan(-y / x);
        }
        if (x >= 0.0) {
            return Math.PI * 2 - Math.atan(-y / x);
        }
        return Math.PI + Math.atan(y / x);
    }

    public static double Clamp(double x, DoubleRange range) {
        return Tools.Clamp(x, range.getMin(), range.getMax());
    }

    public static int Clamp(int x, IntRange range) {
        return Tools.Clamp(x, range.getMin(), range.getMax());
    }

    public static float Clamp(float x, FloatRange range) {
        return Tools.Clamp(x, range.getMin(), range.getMax());
    }

    public static double Clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static int Clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static float Clamp(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static void Clamp(double[] values, List<DoubleRange> ranges) {
        for (int i = 0; i < values.length; ++i) {
            DoubleRange range = ranges.get(i);
            values[i] = values[i] < range.getMin() ? range.getMin() : values[i];
            values[i] = values[i] > range.getMax() ? range.getMax() : values[i];
        }
    }

    public static void Clamp(double[] values, DoubleRange range) {
        Tools.Clamp(values, range.getMin(), range.getMax());
    }

    public static void Clamp(double[] values, double min, double max) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] < min ? min : values[i];
            values[i] = values[i] > max ? max : values[i];
        }
    }

    public static int DigitalRoot(int n) {
        return 1 + (n - 1) % 9;
    }

    public static int GreatestCommonDivisor(int a, int b) {
        int x = a - b * (int)Math.floor(a / b);
        while (x != 0) {
            a = b;
            b = x;
            x = a - b * (int)Math.floor(a / b);
        }
        return b;
    }

    public static boolean isNumeric(String str) {
        int i;
        int start;
        if (str.length() == 0) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isPowerOf2(int x) {
        return x > 0 ? (x & x - 1) == 0 : false;
    }

    public static int Mod(int x, int m) {
        int r;
        if (m < 0) {
            m = -m;
        }
        return (r = x % m) < 0 ? r + m : r;
    }

    public static int NextPowerOf2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }

    public static void Permutate(int[] x) {
        random.permutate(x);
    }

    public static int PreviousPowerOf2(int x) {
        return Tools.NextPowerOf2(x + 1) / 2;
    }

    public static synchronized double RandomNextDouble() {
        return random.nextDouble();
    }

    public static synchronized double RandomLaplacian() {
        return Tools.RandomLaplacian(0.0, 1.0);
    }

    public static synchronized double RandomLaplacian(double mean, double std) {
        double u = random.nextDouble() - 0.5;
        double sigma = std / 1.4142135623730951;
        return mean - sigma * Math.signum(u) * Math.log(1.0 - 2.0 * Math.abs(u));
    }

    public static int Scale(IntRange from, IntRange to, int x) {
        if (from.length() == 0.0) {
            return 0;
        }
        return (int)(to.length() * (double)(x - from.getMin()) / from.length() + (double)to.getMin());
    }

    public static double Scale(DoubleRange from, DoubleRange to, int x) {
        if (from.length() == 0.0) {
            return 0.0;
        }
        return to.length() * ((double)x - from.getMin()) / from.length() + to.getMin();
    }

    public static double Scale(DoubleRange from, DoubleRange to, double x) {
        if (from.length() == 0.0) {
            return 0.0;
        }
        return to.length() * (x - from.getMin()) / from.length() + to.getMin();
    }

    public static float Scale(FloatRange from, FloatRange to, int x) {
        if (from.length() == 0.0f) {
            return 0.0f;
        }
        return to.length() * ((float)x - from.getMin()) / from.length() + to.getMin();
    }

    public static double Scale(double fromMin, double fromMax, double toMin, double toMax, double x) {
        if (fromMax - fromMin == 0.0) {
            return 0.0;
        }
        return (toMax - toMin) * (x - fromMin) / (fromMax - fromMin) + toMin;
    }

    public static float Scale(float fromMin, float fromMax, float toMin, float toMax, float x) {
        if (fromMax - fromMin == 0.0f) {
            return 0.0f;
        }
        return (toMax - toMin) * (x - fromMin) / (fromMax - fromMin) + toMin;
    }

    public static double Sum(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static int Sum(int[] data) {
        int sum = 0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static float Sum(float[] data) {
        float sum = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static double Log(double a, double b) {
        return Math.log(a) / Math.log(b);
    }

    public static double TruncatedPower(double value, double degree) {
        double x = Math.pow(value, degree);
        return x > 0.0 ? x : 0.0;
    }

    public static int[] Unique(int[] values) {
        HashSet<Integer> lst = new HashSet<Integer>();
        for (int i = 0; i < values.length; ++i) {
            lst.add(values[i]);
        }
        int[] v = new int[lst.size()];
        Iterator it = lst.iterator();
        for (int i = 0; i < v.length; ++i) {
            v[i] = (Integer)it.next();
        }
        return v;
    }

    public static double Hypotenuse(double a, double b) {
        double absB;
        double r = 0.0;
        double absA = Math.abs(a);
        if (absA > (absB = Math.abs(b))) {
            r = b / a;
            r = absA * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = absB * Math.sqrt(1.0 + r * r);
        }
        return r;
    }

    public static int Log2(int x) {
        if (x <= 65536) {
            if (x <= 256) {
                if (x <= 16) {
                    if (x <= 4) {
                        if (x <= 2) {
                            if (x <= 1) {
                                return 0;
                            }
                            return 1;
                        }
                        return 2;
                    }
                    if (x <= 8) {
                        return 3;
                    }
                    return 4;
                }
                if (x <= 64) {
                    if (x <= 32) {
                        return 5;
                    }
                    return 6;
                }
                if (x <= 128) {
                    return 7;
                }
                return 8;
            }
            if (x <= 4096) {
                if (x <= 1024) {
                    if (x <= 512) {
                        return 9;
                    }
                    return 10;
                }
                if (x <= 2048) {
                    return 11;
                }
                return 12;
            }
            if (x <= 16384) {
                if (x <= 8192) {
                    return 13;
                }
                return 14;
            }
            if (x <= 32768) {
                return 15;
            }
            return 16;
        }
        if (x <= 0x1000000) {
            if (x <= 0x100000) {
                if (x <= 262144) {
                    if (x <= 131072) {
                        return 17;
                    }
                    return 18;
                }
                if (x <= 524288) {
                    return 19;
                }
                return 20;
            }
            if (x <= 0x400000) {
                if (x <= 0x200000) {
                    return 21;
                }
                return 22;
            }
            if (x <= 0x800000) {
                return 23;
            }
            return 24;
        }
        if (x <= 0x10000000) {
            if (x <= 0x4000000) {
                if (x <= 0x2000000) {
                    return 25;
                }
                return 26;
            }
            if (x <= 0x8000000) {
                return 27;
            }
            return 28;
        }
        if (x <= 0x40000000) {
            if (x <= 0x20000000) {
                return 29;
            }
            return 30;
        }
        return 31;
    }

    public static int Pow2(int power) {
        return power >= 0 && power <= 30 ? 1 << power : 0;
    }
}

