/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

public final class TaylorSeries {
    private TaylorSeries() {
    }

    public static double Sin(double x, int nTerms) {
        if (nTerms < 2) {
            return x;
        }
        if (nTerms == 2) {
            return x - x * x * x / 6.0;
        }
        double mult = x * x * x;
        double fact = 6.0;
        double sign = 1.0;
        int factS = 5;
        double result = x - mult / fact;
        for (int i = 3; i <= nTerms; ++i) {
            result += sign * ((mult *= x * x) / (fact *= (double)((factS += 2) * (factS - 1))));
            sign *= -1.0;
        }
        return result;
    }

    public static double Cos(double x, int nTerms) {
        if (nTerms < 2) {
            return 1.0;
        }
        if (nTerms == 2) {
            return 1.0 - x * x / 2.0;
        }
        double mult = x * x;
        double fact = 2.0;
        double sign = 1.0;
        int factS = 4;
        double result = 1.0 - mult / fact;
        for (int i = 3; i <= nTerms; ++i) {
            result += sign * ((mult *= x * x) / (fact *= (double)((factS += 2) * (factS - 1))));
            sign *= -1.0;
        }
        return result;
    }

    public static double Sinh(double x, int nTerms) {
        if (nTerms < 2) {
            return x;
        }
        if (nTerms == 2) {
            return x + x * x * x / 6.0;
        }
        double mult = x * x * x;
        double fact = 6.0;
        int factS = 5;
        double result = x + mult / fact;
        for (int i = 3; i <= nTerms; ++i) {
            result += (mult *= x * x) / (fact *= (double)((factS += 2) * (factS - 1)));
        }
        return result;
    }

    public static double Cosh(double x, int nTerms) {
        if (nTerms < 2) {
            return x;
        }
        if (nTerms == 2) {
            return 1.0 + x * x / 2.0;
        }
        double mult = x * x;
        double fact = 2.0;
        int factS = 4;
        double result = 1.0 + mult / fact;
        for (int i = 3; i <= nTerms; ++i) {
            result += (mult *= x * x) / (fact *= (double)((factS += 2) * (factS - 1)));
        }
        return result;
    }

    public static double Exp(double x, int nTerms) {
        if (nTerms < 2) {
            return 1.0 + x;
        }
        if (nTerms == 2) {
            return 1.0 + x + x * x / 2.0;
        }
        double mult = x * x;
        double fact = 2.0;
        double result = 1.0 + x + mult / fact;
        for (int i = 3; i <= nTerms; ++i) {
            result += (mult *= x) / (fact *= (double)i);
        }
        return result;
    }
}

