/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Functions.Gamma;
import Catalano.Math.Tools;

public final class Special {
    private static int ftop;
    private static double[] fcache;
    private static double[] lnfcache;

    private Special() {
    }

    public static double Erfc(double value) {
        double q;
        double p;
        double[] P = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] Q = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] R = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] S = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double x = value < 0.0 ? -value : value;
        if (x < 1.0) {
            return 1.0 - Special.Erf(value);
        }
        double z = -value * value;
        if (z < -709.782712893384) {
            if (value < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        z = Math.exp(z);
        if (x < 8.0) {
            p = Special.Polevl(x, P, 8);
            q = Special.P1evl(x, Q, 8);
        } else {
            p = Special.Polevl(x, R, 5);
            q = Special.P1evl(x, S, 6);
        }
        double y = z * p / q;
        if (value < 0.0) {
            y = 2.0 - y;
        }
        if (y == 0.0) {
            if (value < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return y;
    }

    public static double Erf(double x) {
        double[] T = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] U = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(x) > 1.0) {
            return 1.0 - Special.Erfc(x);
        }
        double z = x * x;
        double y = x * Special.Polevl(z, T, 4) / Special.P1evl(z, U, 5);
        return y;
    }

    public static double Polevl(double x, double[] coef, int n) {
        double ans = coef[0];
        for (int i = 1; i <= n; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double P1evl(double x, double[] coef, int n) {
        double ans = x + coef[0];
        for (int i = 1; i < n; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double BSpline(int n, double x) {
        if (n == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("n");
        }
        double a = 1.0 / Special.Factorial(n);
        boolean positive = true;
        for (int k = 0; k <= n + 1; ++k) {
            double c = Special.Binomial(n + 1, k) * Tools.TruncatedPower(x + ((double)n + 1.0) / 2.0 - (double)k, n);
            a += positive ? c : -c;
            positive = !positive;
        }
        return a;
    }

    public static double Binomial(int n, int k) {
        return Math.round(Math.exp(Special.LogFactorial(n) - Special.LogFactorial(k) - Special.LogFactorial(n - k)));
    }

    public static double LogBinomial(int n, int k) {
        return Special.LogFactorial(n) - Special.LogFactorial(k) - Special.LogFactorial(n - k);
    }

    public static double LogFactorial(int n) {
        if (lnfcache == null) {
            lnfcache = new double[101];
        }
        if (n < 0) {
            try {
                throw new ArithmeticException("Argument cannot be negative.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n <= 1) {
            return 0.0;
        }
        if (n <= 100) {
            return lnfcache[n] > 0.0 ? lnfcache[n] : Gamma.Log((double)n + 1.0);
        }
        return Gamma.Log((double)n + 1.0);
    }

    public static double Factorial(int n) {
        if (fcache == null) {
            fcache = new double[33];
            Special.fcache[0] = 1.0;
            Special.fcache[1] = 1.0;
            Special.fcache[2] = 2.0;
            Special.fcache[3] = 6.0;
            Special.fcache[4] = 24.0;
            ftop = 4;
        }
        if (n < 0) {
            try {
                throw new ArithmeticException("Argument cannot be negative.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n > 32) {
            return Math.exp(Gamma.Log((double)n + 1.0));
        }
        while (ftop < n) {
            int j;
            Special.fcache[++Special.ftop] = fcache[j] * (double)ftop;
        }
        return fcache[n];
    }

    public static double Log1m(double x) {
        if (x >= 1.0) {
            return Double.NaN;
        }
        if (Math.abs(x) > 1.0E-4) {
            return Math.log(1.0 - x);
        }
        return -(0.5 * x + 1.0) * x;
    }

    public static double Log1p(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        if (Math.abs(x) > 1.0E-4) {
            return Math.log(1.0 + x);
        }
        return (-0.5 * x + 1.0) * x;
    }

    public static double Expm1(double x) {
        if (Math.abs(x) < 1.0E-5) {
            return x + 0.5 * x * x;
        }
        return Math.exp(x) - 1.0;
    }

    public static double Epslon(double x) {
        double eps = 0.0;
        double a = 1.3333333333333333;
        while (eps == 0.0) {
            double b = a - 1.0;
            double c = b + b + b;
            eps = Math.abs(c - 1.0);
        }
        return eps * Math.abs(x);
    }

    public static double Sign(double a, double b) {
        double x = a >= 0.0 ? a : -a;
        return b >= 0.0 ? x : -x;
    }

    public static double LogDiff(double lna, double lnc) {
        if (lna > lnc) {
            return lna + Math.exp(1.0 - Math.exp(lnc - lna));
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static double LogSum(double lna, double lnc) {
        if (lna == Double.NEGATIVE_INFINITY) {
            return lnc;
        }
        if (lnc == Double.NEGATIVE_INFINITY) {
            return lna;
        }
        if (lna > lnc) {
            return lna + Special.Log1p(Math.exp(lnc - lna));
        }
        return lnc + Special.Log1p(Math.exp(lna - lnc));
    }

    public static double LogSum(float lna, float lnc) {
        if (lna == Float.NEGATIVE_INFINITY) {
            return lnc;
        }
        if (lnc == Float.NEGATIVE_INFINITY) {
            return lna;
        }
        if (lna > lnc) {
            return (double)lna + Special.Log1p(Math.exp(lnc - lna));
        }
        return (double)lnc + Special.Log1p(Math.exp(lna - lnc));
    }
}

