/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Optimization;

import Catalano.Math.Matrix;
import Catalano.Math.Optimization.Constraint;
import Catalano.Math.Optimization.Tableau;
import java.util.Arrays;
import java.util.List;

public class LinearProgramming {
    public static final int INFEASIBLE = 0;
    public static final int OPTIMAL = 1;
    public static final int UNBOUNDED = 2;
    private static final int SECOND_PHASE = -2;
    private double[] function;
    private Objective objective;
    private double[] r;
    private double solution;
    private boolean isInfinite;
    private int iterations;
    private List<Constraint> constraints;

    public int getIterations() {
        return this.iterations;
    }

    public double getSolution() {
        return this.solution;
    }

    public double[] getCoefficients() {
        return this.r;
    }

    public LinearProgramming(Objective objective) {
        this.objective = objective;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    /*
     * Unable to fully structure code
     */
    public int Solve(double[] function, List<Constraint> constraints) {
        this.function = function;
        this.constraints = constraints;
        this.iterations = 0;
        this.isInfinite = false;
        tableau = this.CreateTableau(function, constraints);
        tab = tableau.getTableau();
        vars = tableau.getCoefVars();
        basis = tableau.getBasis();
        status = -1;
        while (true) {
            ++this.iterations;
            q = this.findColumn(tab, vars, basis);
            if (q == -2) {
                tableau = this.CreateSecondTableau(tab, vars, basis);
                tab = tableau.getTableau();
                vars = tableau.getCoefVars();
                basis = tableau.getBasis();
            }
            if (q >= 0 && this.isUnbounded(tab, q)) {
                return 2;
            }
            if (q == -1) {
                if (this.isInfeasible(tab, vars, basis)) {
                    return 0;
                }
                break;
            }
            if (q < 0) continue;
            p = this.findRow(tab, q, vars, basis);
            basis[p] = q;
            pivot = tab[p][q];
            i = 0;
            while (i < tab[0].length) {
                v0 = tab[p];
                v1 = i++;
                v0[v1] = v0[v1] / pivot;
            }
            i = 0;
            while (true) {
                if (i >= tab.length) ** break;
                if (i != p) {
                    pivot = tab[i][q];
                    for (j = 0; j < tab[0].length; ++j) {
                        tab[i][j] = tab[i][j] - pivot * tab[p][j];
                    }
                }
                ++i;
            }
            break;
        }
        status = 1;
        this.r = new double[vars.length];
        for (i = 0; i < basis.length; ++i) {
            this.r[basis[i]] = tab[i][tab[0].length - 1];
        }
        this.solution = 0.0;
        for (i = 0; i < function.length; ++i) {
            this.solution += function[i] * this.r[i];
        }
        if (this.objective == Objective.Minimize) {
            i = 0;
            while (i < function.length) {
                v2 = i++;
                function[v2] = function[v2] * -1.0;
            }
        }
        if (this.objective == Objective.Minimize) {
            this.solution = -this.solution;
        }
        this.r = Arrays.copyOf(this.r, function.length);
        return status;
    }

    private Tableau CreateSecondTableau(double[][] tableau, double[] vars, int[] basis) {
        int i;
        int c = 0;
        for (int i2 = 0; i2 < vars.length; ++i2) {
            if (vars[i2] != -1.0) continue;
            ++c;
        }
        int[] index = new int[c];
        int idx = 0;
        for (i = 0; i < vars.length; ++i) {
            if (vars[i] != -1.0) continue;
            index[idx] = i;
            ++idx;
        }
        tableau = Matrix.RemoveColumns(tableau, index);
        vars = new double[tableau[0].length];
        for (i = 0; i < this.function.length; ++i) {
            vars[i] = this.function[i];
        }
        return new Tableau(tableau, vars, basis);
    }

    private boolean isUnbounded(double[][] tableau, int q) {
        int c = 0;
        for (int i = 0; i < tableau.length; ++i) {
            if (!(tableau[i][q] <= 0.0)) continue;
            ++c;
        }
        return c == tableau.length;
    }

    private boolean isInfeasible(double[][] tableau, double[] artVariables, int[] basis) {
        for (int i = 0; i < tableau.length; ++i) {
            if (!(tableau[i][tableau[0].length - 1] > 0.0) || artVariables[basis[i]] != -1.0) continue;
            return true;
        }
        return false;
    }

    private int findColumn(double[][] tableau, double[] coef, int[] basis) {
        int i;
        double[] z = new double[tableau[0].length - 1];
        for (i = 0; i < tableau.length; ++i) {
            for (int j = 0; j < tableau[0].length - 1; ++j) {
                int n = j;
                z[n] = z[n] + tableau[i][j] * coef[basis[i]];
            }
        }
        for (i = 0; i < coef.length - 1; ++i) {
            z[i] = z[i] - coef[i];
        }
        boolean isOptimal = true;
        for (int i2 = 0; i2 < z.length; ++i2) {
            if (!(z[i2] < 0.0)) continue;
            isOptimal = false;
        }
        if (isOptimal) {
            int i3;
            double sum = 0.0;
            for (i3 = 0; i3 < tableau.length; ++i3) {
                sum += tableau[i3][tableau[0].length - 1] * coef[basis[i3]];
            }
            if (sum == 0.0) {
                return -2;
            }
            for (i3 = 0; i3 < basis.length; ++i3) {
                coef[basis[i3]] = Double.NaN;
            }
            int c = 0;
            for (int i4 = 0; i4 < z.length; ++i4) {
                if (Double.isNaN(coef[i4]) || z[i4] != 0.0) continue;
                ++c;
            }
            if (c > 0) {
                this.isInfinite = true;
            }
            return -1;
        }
        if (isOptimal) {
            return -1;
        }
        return Matrix.MinIndex(z);
    }

    private int findRow(double[][] tableau, int q, double[] artVar, int[] basis) {
        int i;
        double min = Double.MAX_VALUE;
        double[] div = new double[tableau.length];
        for (int i2 = 0; i2 < div.length; ++i2) {
            if (tableau[i2][q] > 0.0) {
                div[i2] = tableau[i2][tableau[0].length - 1] / tableau[i2][q];
                min = Math.min(min, div[i2]);
                continue;
            }
            div[i2] = Double.MAX_VALUE;
        }
        int c = 0;
        for (i = 0; i < div.length; ++i) {
            if (div[i] != min) continue;
            ++c;
        }
        if (c == 1) {
            return Matrix.MinIndex(div);
        }
        for (i = 0; i < div.length; ++i) {
            if (div[i] != min || artVar[basis[i]] != -1.0) continue;
            return i;
        }
        return Matrix.MinIndex(div);
    }

    private Tableau CreateTableau(double[] function, List<Constraint> constraint) {
        Constraint c;
        int i;
        if (this.objective == Objective.Minimize) {
            int i2 = 0;
            while (i2 < function.length) {
                int n = i2++;
                function[n] = function[n] * -1.0;
            }
        }
        boolean hasArtificialVariable = false;
        int nBasic = 0;
        int nArtificial = 0;
        int vars = 0;
        for (Constraint c2 : constraint) {
            switch (c2.getSymbol()) {
                case LESS_THAN: {
                    ++nBasic;
                    break;
                }
                case EQUAL_TO: {
                    ++nArtificial;
                    break;
                }
                case GREATER_THAN: {
                    ++nBasic;
                    ++nArtificial;
                }
            }
        }
        vars = nBasic + nArtificial;
        if (nArtificial > 0) {
            hasArtificialVariable = true;
        }
        double[][] tableau = new double[constraint.size()][function.length + vars + 1];
        int[] basis = new int[constraint.size()];
        for (i = 0; i < basis.length; ++i) {
            basis[i] = i;
        }
        for (i = 0; i < constraint.size(); ++i) {
            c = constraint.get(i);
            for (int j = 0; j < function.length; ++j) {
                tableau[i][j] = c.getRightSide() >= 0.0 ? c.getLeftSide()[j] : -c.getLeftSide()[j];
            }
        }
        for (i = 0; i < constraint.size(); ++i) {
            c = constraint.get(i);
            tableau[i][tableau[0].length - 1] = c.getRightSide() >= 0.0 ? c.getRightSide() : -c.getRightSide();
        }
        double[] t = new double[function.length + vars + 1];
        if (!hasArtificialVariable) {
            for (int i3 = 0; i3 < function.length; ++i3) {
                t[i3] = function[i3];
            }
        }
        int movesSx = function.length;
        int movesAx = function.length + nBasic;
        block22: for (int i4 = 0; i4 < constraint.size(); ++i4) {
            Constraint c3 = constraint.get(i4);
            if (c3.getRightSide() >= 0.0) {
                switch (c3.getSymbol()) {
                    case LESS_THAN: {
                        tableau[i4][movesSx] = 1.0;
                        basis[i4] = movesSx++;
                        break;
                    }
                    case EQUAL_TO: {
                        tableau[i4][movesAx] = 1.0;
                        basis[i4] = movesAx;
                        t[movesAx] = -1.0;
                        ++movesAx;
                        break;
                    }
                    case GREATER_THAN: {
                        tableau[i4][movesSx] = -1.0;
                        tableau[i4][movesAx] = 1.0;
                        t[movesSx] = 0.0;
                        t[movesAx] = -1.0;
                        basis[i4] = movesAx++;
                        ++movesSx;
                    }
                }
                continue;
            }
            switch (c3.getSymbol()) {
                case LESS_THAN: {
                    tableau[i4][movesSx] = -1.0;
                    tableau[i4][movesAx] = 1.0;
                    t[movesSx] = 0.0;
                    t[movesAx] = -1.0;
                    basis[i4] = movesAx++;
                    ++movesSx;
                    continue block22;
                }
                case EQUAL_TO: {
                    tableau[i4][movesAx] = 1.0;
                    basis[i4] = movesAx;
                    t[movesAx] = -1.0;
                    ++movesAx;
                    continue block22;
                }
                case GREATER_THAN: {
                    tableau[i4][movesSx] = 1.0;
                    basis[i4] = movesSx++;
                }
            }
        }
        return new Tableau(tableau, t, basis);
    }

    public static enum Objective {
        Minimize,
        Maximize;

    }
}

