/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import Catalano.Math.Distances.Distance;
import Catalano.Math.Geometry.IShapeOptimizer;
import java.util.ArrayList;
import java.util.List;

public class RamerDouglasPeucker
implements IShapeOptimizer {
    private double distanceThreshold;

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public void setDistanceThreshold(double distanceThreshold) {
        this.distanceThreshold = distanceThreshold;
    }

    public RamerDouglasPeucker() {
        this(0.5);
    }

    public RamerDouglasPeucker(double distanceThreshold) {
        this.distanceThreshold = distanceThreshold;
    }

    @Override
    public List<IntPoint> OptimizeShape(List<IntPoint> shape) {
        ArrayList<IntPoint> simplifiedVertices = new ArrayList<IntPoint>();
        Double maxDistance = null;
        int maxDistancePointIdx = 0;
        int lastPointIdx = shape.size() - 1;
        int currentIdx = 0;
        for (IntPoint aVertex : shape) {
            if (currentIdx != 0 && currentIdx != lastPointIdx) {
                Double distance = this.shortestDistanceToSegment(aVertex, shape.get(0), shape.get(lastPointIdx));
                if (maxDistance == null || distance > maxDistance) {
                    maxDistancePointIdx = currentIdx;
                    maxDistance = distance;
                }
            }
            ++currentIdx;
        }
        if (maxDistance != null) {
            if (maxDistance > this.distanceThreshold) {
                List<IntPoint> sub = this.OptimizeShape(shape.subList(0, maxDistancePointIdx + 1));
                List<IntPoint> sup = this.OptimizeShape(shape.subList(maxDistancePointIdx, lastPointIdx + 1));
                simplifiedVertices.addAll(sub);
                simplifiedVertices.addAll(sup);
            } else {
                simplifiedVertices.add(shape.get(0));
                simplifiedVertices.add(shape.get(lastPointIdx));
            }
        }
        return simplifiedVertices;
    }

    private double shortestDistanceToSegment(IntPoint thePoint, IntPoint segmentPoint_A, IntPoint segmentPoint_B) {
        double area = this.calculateTriangleAreaGivenVertices(thePoint, segmentPoint_A, segmentPoint_B);
        double lengthSegment = Distance.Euclidean(segmentPoint_A, segmentPoint_B);
        return 2.0 * area / lengthSegment;
    }

    private double calculateTriangleAreaGivenVertices(IntPoint a, IntPoint b, IntPoint c) {
        double area = Math.abs((a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y)) / 2);
        return area;
    }
}

