/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import java.util.List;

public final class QuadrilateralTransformationCalc {
    private static final double TOLERANCE = 1.0E-13;

    private QuadrilateralTransformationCalc() {
    }

    private static double Det2(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private static double[][] MultiplyMatrix(double[][] a, double[][] b) {
        double[][] c = new double[3][3];
        c[0][0] = a[0][0] * b[0][0] + a[0][1] * b[1][0] + a[0][2] * b[2][0];
        c[0][1] = a[0][0] * b[0][1] + a[0][1] * b[1][1] + a[0][2] * b[2][1];
        c[0][2] = a[0][0] * b[0][2] + a[0][1] * b[1][2] + a[0][2] * b[2][2];
        c[1][0] = a[1][0] * b[0][0] + a[1][1] * b[1][0] + a[1][2] * b[2][0];
        c[1][1] = a[1][0] * b[0][1] + a[1][1] * b[1][1] + a[1][2] * b[2][1];
        c[1][2] = a[1][0] * b[0][2] + a[1][1] * b[1][2] + a[1][2] * b[2][2];
        c[2][0] = a[2][0] * b[0][0] + a[2][1] * b[1][0] + a[2][2] * b[2][0];
        c[2][1] = a[2][0] * b[0][1] + a[2][1] * b[1][1] + a[2][2] * b[2][1];
        c[2][2] = a[2][0] * b[0][2] + a[2][1] * b[1][2] + a[2][2] * b[2][2];
        return c;
    }

    private static double[][] AdjugateMatrix(double[][] a) {
        double[][] b = new double[3][3];
        b[0][0] = QuadrilateralTransformationCalc.Det2(a[1][1], a[1][2], a[2][1], a[2][2]);
        b[1][0] = QuadrilateralTransformationCalc.Det2(a[1][2], a[1][0], a[2][2], a[2][0]);
        b[2][0] = QuadrilateralTransformationCalc.Det2(a[1][0], a[1][1], a[2][0], a[2][1]);
        b[0][1] = QuadrilateralTransformationCalc.Det2(a[2][1], a[2][2], a[0][1], a[0][2]);
        b[1][1] = QuadrilateralTransformationCalc.Det2(a[2][2], a[2][0], a[0][2], a[0][0]);
        b[2][1] = QuadrilateralTransformationCalc.Det2(a[2][0], a[2][1], a[0][0], a[0][1]);
        b[0][2] = QuadrilateralTransformationCalc.Det2(a[0][1], a[0][2], a[1][1], a[1][2]);
        b[1][2] = QuadrilateralTransformationCalc.Det2(a[0][2], a[0][0], a[1][2], a[1][0]);
        b[2][2] = QuadrilateralTransformationCalc.Det2(a[0][0], a[0][1], a[1][0], a[1][1]);
        return b;
    }

    private static double[][] MapSquareToQuad(List<IntPoint> quad) {
        double[][] sq = new double[3][3];
        double px = quad.get((int)0).x - quad.get((int)1).x + quad.get((int)2).x - quad.get((int)3).x;
        double py = quad.get((int)0).y - quad.get((int)1).y + quad.get((int)2).y - quad.get((int)3).y;
        if (px < 1.0E-13 && px > -1.0E-13 && py < 1.0E-13 && py > -1.0E-13) {
            sq[0][0] = quad.get((int)1).x - quad.get((int)0).x;
            sq[0][1] = quad.get((int)2).x - quad.get((int)1).x;
            sq[0][2] = quad.get((int)0).x;
            sq[1][0] = quad.get((int)1).y - quad.get((int)0).y;
            sq[1][1] = quad.get((int)2).y - quad.get((int)1).y;
            sq[1][2] = quad.get((int)0).y;
            sq[2][0] = 0.0;
            sq[2][1] = 0.0;
            sq[2][2] = 1.0;
        } else {
            double dx1 = quad.get((int)1).x - quad.get((int)2).x;
            double dx2 = quad.get((int)3).x - quad.get((int)2).x;
            double dy1 = quad.get((int)1).y - quad.get((int)2).y;
            double dy2 = quad.get((int)3).y - quad.get((int)2).y;
            double del = QuadrilateralTransformationCalc.Det2(dx1, dx2, dy1, dy2);
            if (del == 0.0) {
                return null;
            }
            sq[2][0] = QuadrilateralTransformationCalc.Det2(px, dx2, py, dy2) / del;
            sq[2][1] = QuadrilateralTransformationCalc.Det2(dx1, px, dy1, py) / del;
            sq[2][2] = 1.0;
            sq[0][0] = (double)(quad.get((int)1).x - quad.get((int)0).x) + sq[2][0] * (double)quad.get((int)1).x;
            sq[0][1] = (double)(quad.get((int)3).x - quad.get((int)0).x) + sq[2][1] * (double)quad.get((int)3).x;
            sq[0][2] = quad.get((int)0).x;
            sq[1][0] = (double)(quad.get((int)1).y - quad.get((int)0).y) + sq[2][0] * (double)quad.get((int)1).y;
            sq[1][1] = (double)(quad.get((int)3).y - quad.get((int)0).y) + sq[2][1] * (double)quad.get((int)3).y;
            sq[1][2] = quad.get((int)0).y;
        }
        return sq;
    }

    public static double[][] MapQuadToQuad(List<IntPoint> input, List<IntPoint> output) {
        double[][] squareToInpit = QuadrilateralTransformationCalc.MapSquareToQuad(input);
        double[][] squareToOutput = QuadrilateralTransformationCalc.MapSquareToQuad(output);
        if (squareToOutput == null) {
            return null;
        }
        return QuadrilateralTransformationCalc.MultiplyMatrix(squareToOutput, QuadrilateralTransformationCalc.AdjugateMatrix(squareToInpit));
    }
}

