/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import Catalano.Math.Geometry.PointToProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GrahamConvexHull {
    public List<IntPoint> FindHull(List<IntPoint> points) {
        int i;
        ArrayList<PointToProcess> pointsToProcess = new ArrayList<PointToProcess>();
        for (IntPoint p : points) {
            pointsToProcess.add(new PointToProcess(p));
        }
        int firstCornerIndex = 0;
        PointToProcess firstCorner = (PointToProcess)pointsToProcess.get(0);
        int n = pointsToProcess.size();
        for (i = 1; i < n; ++i) {
            if (((PointToProcess)pointsToProcess.get((int)i)).x >= firstCorner.x && (((PointToProcess)pointsToProcess.get((int)i)).x != firstCorner.x || ((PointToProcess)pointsToProcess.get((int)i)).y >= firstCorner.y)) continue;
            firstCorner = (PointToProcess)pointsToProcess.get(i);
            firstCornerIndex = i;
        }
        pointsToProcess.remove(firstCornerIndex);
        n = pointsToProcess.size();
        for (i = 0; i < n; ++i) {
            int dx = ((PointToProcess)pointsToProcess.get((int)i)).x - firstCorner.x;
            int dy = ((PointToProcess)pointsToProcess.get((int)i)).y - firstCorner.y;
            ((PointToProcess)pointsToProcess.get((int)i)).distance = dx * dx + dy * dy;
            ((PointToProcess)pointsToProcess.get((int)i)).k = dx == 0 ? Float.POSITIVE_INFINITY : (float)dy / (float)dx;
        }
        Collections.sort(pointsToProcess);
        ArrayList<PointToProcess> convexHullTemp = new ArrayList<PointToProcess>();
        convexHullTemp.add(firstCorner);
        convexHullTemp.add((PointToProcess)pointsToProcess.get(0));
        pointsToProcess.remove(0);
        PointToProcess lastPoint = (PointToProcess)convexHullTemp.get(1);
        PointToProcess prevPoint = (PointToProcess)convexHullTemp.get(0);
        while (!pointsToProcess.isEmpty()) {
            PointToProcess newPoint = (PointToProcess)pointsToProcess.get(0);
            if (newPoint.k == lastPoint.k || newPoint.distance == 0.0f) {
                pointsToProcess.remove(0);
                continue;
            }
            if ((newPoint.x - prevPoint.x) * (lastPoint.y - newPoint.y) - (lastPoint.x - newPoint.x) * (newPoint.y - prevPoint.y) < 0) {
                convexHullTemp.add(newPoint);
                pointsToProcess.remove(0);
                prevPoint = lastPoint;
                lastPoint = newPoint;
                continue;
            }
            convexHullTemp.remove(convexHullTemp.size() - 1);
            lastPoint = prevPoint;
            prevPoint = (PointToProcess)convexHullTemp.get(convexHullTemp.size() - 2);
        }
        ArrayList<IntPoint> convexHull = new ArrayList<IntPoint>();
        for (PointToProcess p : convexHullTemp) {
            convexHull.add(p.toPoint());
        }
        return convexHull;
    }
}

