/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import Catalano.Math.Geometry.GeometryTools;
import Catalano.Math.Geometry.IShapeOptimizer;
import java.util.ArrayList;
import java.util.List;

public class FlatAnglesOptimizer
implements IShapeOptimizer {
    private float maxAngleToKeep = 160.0f;

    public FlatAnglesOptimizer() {
    }

    public FlatAnglesOptimizer(float maxAngleToKeep) {
        this.maxAngleToKeep = maxAngleToKeep;
    }

    public float getMaxAngleToKeep() {
        return this.maxAngleToKeep;
    }

    public void setMaxAngleToKeep(float maxAngleToKeep) {
        this.maxAngleToKeep = Math.min(180.0f, Math.max(140.0f, maxAngleToKeep));
    }

    @Override
    public List<IntPoint> OptimizeShape(List<IntPoint> shape) {
        ArrayList<IntPoint> optimizedShape = new ArrayList<IntPoint>();
        if (shape.size() <= 3) {
            optimizedShape.addAll(shape);
        } else {
            float angle = 0.0f;
            optimizedShape.add(shape.get(0));
            optimizedShape.add(shape.get(1));
            int pointsInOptimizedHull = 2;
            int n = shape.size();
            for (int i = 2; i < n; ++i) {
                optimizedShape.add(shape.get(i));
                angle = GeometryTools.GetAngleBetweenVectors(optimizedShape.get(++pointsInOptimizedHull - 2), optimizedShape.get(pointsInOptimizedHull - 3), optimizedShape.get(pointsInOptimizedHull - 1));
                if (!(angle > this.maxAngleToKeep) || pointsInOptimizedHull <= 3 && i >= n - 1) continue;
                optimizedShape.remove(pointsInOptimizedHull - 2);
                --pointsInOptimizedHull;
            }
            if (pointsInOptimizedHull > 3) {
                angle = GeometryTools.GetAngleBetweenVectors(optimizedShape.get(pointsInOptimizedHull - 1), optimizedShape.get(pointsInOptimizedHull - 2), optimizedShape.get(0));
                if (angle > this.maxAngleToKeep) {
                    optimizedShape.remove(pointsInOptimizedHull - 1);
                    --pointsInOptimizedHull;
                }
                if (pointsInOptimizedHull > 3 && (angle = GeometryTools.GetAngleBetweenVectors(optimizedShape.get(0), optimizedShape.get(pointsInOptimizedHull - 1), optimizedShape.get(1))) > this.maxAngleToKeep) {
                    optimizedShape.remove(0);
                }
            }
        }
        return optimizedShape;
    }
}

