/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.IntPoint;
import Catalano.Math.Geometry.ConvexityDefect;
import Catalano.Math.Geometry.Line;
import java.util.ArrayList;
import java.util.List;

public class ConvexHullDefects {
    private double minimumDepth;

    public ConvexHullDefects(double minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public double getMinimumDepth() {
        return this.minimumDepth;
    }

    public void setMinimumDepth(double minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public List<ConvexityDefect> FindDefects(List<IntPoint> contour, List<IntPoint> convexHull) {
        try {
            if (contour.size() < 4) {
                throw new Exception("Point sequence size should have at least 4 points.");
            }
            if (convexHull.size() < 3) {
                throw new Exception("Convex hull must have at least 3 points.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] indexes = new int[convexHull.size()];
        int j = 0;
        for (int i = 0; i < contour.size(); ++i) {
            if (!convexHull.contains(contour.get(i))) continue;
            indexes[j++] = i;
        }
        ArrayList<ConvexityDefect> defects = new ArrayList<ConvexityDefect>();
        for (int i = 0; i < indexes.length - 1; ++i) {
            ConvexityDefect current = this.ExtractDefect(contour, indexes[i], indexes[i + 1]);
            if (!(current.getDepth() > this.minimumDepth)) continue;
            defects.add(current);
        }
        return defects;
    }

    private ConvexityDefect ExtractDefect(List<IntPoint> contour, int startIndex, int endIndex) {
        IntPoint start = contour.get(startIndex);
        IntPoint end = contour.get(endIndex);
        Line line = Line.FromPoints(start, end);
        double maxDepth = 0.0;
        int maxIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            double d = line.DistanceToPoint(contour.get(i));
            if (!(d > maxDepth)) continue;
            maxDepth = d;
            maxIndex = i;
        }
        return new ConvexityDefect(contour.get(maxIndex), startIndex, endIndex, maxDepth);
    }
}

