/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

public class Gaussian {
    private double sigma = 1.0;
    private double sqrSigma = 1.0;

    public Gaussian(double sigma) {
        this.setSigma(sigma);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = Math.max(1.0E-8, sigma);
        this.sqrSigma = sigma * sigma;
    }

    public double Function1D(double x) {
        return Math.exp(x * x / (-2.0 * this.sqrSigma)) / (Math.sqrt(Math.PI * 2) * this.sigma);
    }

    public double Function2D(double x, double y) {
        return Math.exp(-(x * x + y * y) / (2.0 * this.sqrSigma)) / (Math.PI * 2 * this.sqrSigma);
    }

    public double[] Kernel1D(int size) {
        if (size % 2 == 0 || size < 3 || size > 101) {
            try {
                throw new Exception("Wrong size");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int r = size / 2;
        double[] kernel = new double[size];
        int x = -r;
        for (int i = 0; i < size; ++i) {
            kernel[i] = this.Function1D(x);
            ++x;
        }
        return kernel;
    }

    public double[][] Kernel2D(int size) {
        if (size % 2 == 0 || size < 3 || size > 101) {
            try {
                throw new Exception("Wrong size");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int r = size / 2;
        double[][] kernel = new double[size][size];
        double sum = 0.0;
        int y = -r;
        for (int i = 0; i < size; ++i) {
            int x = -r;
            for (int j = 0; j < size; ++j) {
                kernel[i][j] = this.Function2D(x, y);
                sum += kernel[i][j];
                ++x;
            }
            ++y;
        }
        for (int i = 0; i < kernel.length; ++i) {
            int j = 0;
            while (j < kernel[0].length) {
                double[] dArray = kernel[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        return kernel;
    }
}

