/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

import Catalano.Math.ComplexNumber;

public final class Gabor {
    private Gabor() {
    }

    public static double Function1D(double x, double mean, double amplitude, double position, double width, double phase, double frequency) {
        double envelope = mean + amplitude * Math.exp(-Math.pow(x - position, 2.0) / Math.pow(2.0 * width, 2.0));
        double carry = Math.cos(Math.PI * 2 * frequency * (x - position) + phase);
        return envelope * carry;
    }

    public static ComplexNumber Function2D(int x, int y, double wavelength, double orientation, double phaseOffset, double gaussVariance, double aspectRatio) {
        double X = (double)x * Math.cos(orientation) + (double)y * Math.sin(orientation);
        double Y = (double)(-x) * Math.sin(orientation) + (double)y * Math.cos(orientation);
        double envelope = Math.exp(-((X * X + aspectRatio * aspectRatio * Y * Y) / (2.0 * gaussVariance * gaussVariance)));
        double real = Math.cos(Math.PI * 2 * (X / wavelength) + phaseOffset);
        double imaginary = Math.sin(Math.PI * 2 * (X / wavelength) + phaseOffset);
        return new ComplexNumber(envelope * real, envelope * imaginary);
    }

    public static double RealFunction2D(int x, int y, double wavelength, double orientation, double phaseOffset, double gaussVariance, double aspectRatio) {
        double X = (double)x * Math.cos(orientation) + (double)y * Math.sin(orientation);
        double Y = (double)(-x) * Math.sin(orientation) + (double)y * Math.cos(orientation);
        double envelope = Math.exp(-((X * X + aspectRatio * aspectRatio * Y * Y) / (2.0 * gaussVariance * gaussVariance)));
        double carrier = Math.cos(Math.PI * 2 * (X / wavelength) + phaseOffset);
        return envelope * carrier;
    }

    public static double ImaginaryFunction2D(int x, int y, double wavelength, double orientation, double phaseOffset, double gaussVariance, double aspectRatio) {
        double X = (double)x * Math.cos(orientation) + (double)y * Math.sin(orientation);
        double Y = (double)(-x) * Math.sin(orientation) + (double)y * Math.cos(orientation);
        double envelope = Math.exp(-((X * X + aspectRatio * aspectRatio * Y * Y) / (2.0 * gaussVariance * gaussVariance)));
        double carrier = Math.sin(Math.PI * 2 * (X / wavelength) + phaseOffset);
        return envelope * carrier;
    }

    public static double[][] Kernel2D(int size, double wavelength, double orientation, double phaseOffset, double gaussVariance, double aspectRatio) {
        int y;
        int x;
        double sigmaX = gaussVariance;
        double sigmaY = gaussVariance / aspectRatio;
        int xMax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)size * sigmaX * Math.cos(orientation)), Math.abs((double)size * sigmaY * Math.sin(orientation)))));
        int yMax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)size * sigmaX * Math.sin(orientation)), Math.abs((double)size * sigmaY * Math.cos(orientation)))));
        double[][] kernel = new double[2 * xMax + 1][2 * yMax + 1];
        double sum = 0.0;
        for (x = -xMax; x <= xMax; ++x) {
            for (y = -yMax; y <= yMax; ++y) {
                kernel[x + xMax][y + yMax] = Gabor.ImaginaryFunction2D(x, y, wavelength, orientation, phaseOffset, gaussVariance, aspectRatio);
                sum += kernel[x + xMax][y + yMax];
            }
        }
        for (x = -xMax; x <= xMax; ++x) {
            for (y = -yMax; y <= yMax; ++y) {
                double[] dArray = kernel[x + xMax];
                int n = y + yMax;
                dArray[n] = dArray[n] / sum;
            }
        }
        return kernel;
    }

    public static double[][] Kernel2D(int size, double wavelength, double orientation, double phaseOffset, double gaussVariance, double aspectRatio, Config config) {
        int y;
        int x;
        double sigmaX = gaussVariance;
        double sigmaY = gaussVariance / aspectRatio;
        int xMax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)size * sigmaX * Math.cos(orientation)), Math.abs((double)size * sigmaY * Math.sin(orientation)))));
        int yMax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)size * sigmaX * Math.sin(orientation)), Math.abs((double)size * sigmaY * Math.cos(orientation)))));
        double[][] kernel = new double[2 * xMax + 1][2 * yMax + 1];
        double sum = 0.0;
        switch (config) {
            case Real: {
                for (x = -xMax; x <= xMax; ++x) {
                    for (y = -yMax; y <= yMax; ++y) {
                        kernel[x + xMax][y + yMax] = Gabor.RealFunction2D(x, y, wavelength, orientation, phaseOffset, gaussVariance, aspectRatio);
                        sum += kernel[x + xMax][y + yMax];
                    }
                }
                break;
            }
            case Imaginary: {
                for (x = -xMax; x <= xMax; ++x) {
                    for (y = -yMax; y <= yMax; ++y) {
                        kernel[x + xMax][y + yMax] = Gabor.ImaginaryFunction2D(x, y, wavelength, orientation, phaseOffset, gaussVariance, aspectRatio);
                        sum += kernel[x + xMax][y + yMax];
                    }
                }
                break;
            }
            case Magnitude: {
                ComplexNumber c;
                for (x = -xMax; x <= xMax; ++x) {
                    for (y = -yMax; y <= yMax; ++y) {
                        c = Gabor.Function2D(x, y, wavelength, orientation, phaseOffset, gaussVariance, aspectRatio);
                        kernel[x + xMax][y + yMax] = c.getMagnitude();
                        sum += kernel[x + xMax][y + yMax];
                    }
                }
                break;
            }
            case SquaredMagnitude: {
                ComplexNumber c;
                for (x = -xMax; x <= xMax; ++x) {
                    for (y = -yMax; y <= yMax; ++y) {
                        c = Gabor.Function2D(x, y, wavelength, orientation, phaseOffset, gaussVariance, aspectRatio);
                        kernel[x + xMax][y + yMax] = c.getSquaredMagnitude();
                        sum += kernel[x + xMax][y + yMax];
                    }
                }
                break;
            }
        }
        for (x = -xMax; x <= xMax; ++x) {
            for (y = -yMax; y <= yMax; ++y) {
                double[] dArray = kernel[x + xMax];
                int n = y + yMax;
                dArray[n] = dArray[n] / sum;
            }
        }
        return kernel;
    }

    public static enum Config {
        Real,
        Imaginary,
        Magnitude,
        SquaredMagnitude;

    }
}

