/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;

public class SingerMap
implements IChaoticFunction {
    private double u;

    public SingerMap() {
        this(1.07);
    }

    public SingerMap(double u) {
        this.u = u;
    }

    @Override
    public double Generate(double x) {
        return this.u * (7.86 * x - 23.31 * (x * x) + 28.75 * (x * x * x) - 13.302875 * (x * x * x * x));
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

