/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;
import Catalano.Math.Tools;

public class IterativeMap
implements IChaoticFunction {
    private double a;

    public IterativeMap() {
        this(0.7);
    }

    public IterativeMap(double a) {
        this.a = a;
    }

    @Override
    public double Generate(double x) {
        double r = Math.sin(this.a * Math.PI / x);
        return Tools.Scale(-1.0, 1.0, 0.0, 1.0, r);
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

