/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Dissimilarities;

public final class Dissimilarity {
    private Dissimilarity() {
    }

    public static double Dice(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] != 1 || y[i] != 1) continue;
            ++tt;
        }
        return (double)(tf + ft) / (double)(2 * tt + ft + tf);
    }

    public static double Jaccard(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] != 1 || y[i] != 1) continue;
            ++tt;
        }
        return (double)(tf + ft) / (double)(tt + ft + tf);
    }

    public static double Kulsinsk(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] != 1 || y[i] != 1) continue;
            ++tt;
        }
        return (double)(tf + ft - tt + x.length) / (double)(ft + tf + x.length);
    }

    public static double Matching(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] != 0 || y[i] != 1) continue;
            ++ft;
        }
        return (double)(tf + ft) / (double)x.length;
    }

    public static double RogersTanimoto(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        int ff = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] == 1 && y[i] == 1) {
                ++tt;
            }
            if (x[i] != 0 || y[i] != 0) continue;
            ++ff;
        }
        int r = 2 * (tf + ft);
        return (double)r / (double)(tt + ff + r);
    }

    public static double RusselRao(int[] x, int[] y) {
        int tt = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] != 1 || y[i] != 1) continue;
            ++tt;
        }
        return (double)(x.length - tt) / (double)x.length;
    }

    public static double SokalMichener(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        int ff = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] == 1 && y[i] == 1) {
                ++tt;
            }
            if (x[i] != 0 || y[i] != 0) continue;
            ++ff;
        }
        int r = 2 * (tf + ft);
        return (double)r / (double)(ff + tt + r);
    }

    public static double SokalSneath(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] != 1 || y[i] != 1) continue;
            ++tt;
        }
        int r = 2 * (tf + ft);
        return (double)r / (double)(tt + r);
    }

    public static double Yule(int[] x, int[] y) {
        int tf = 0;
        int ft = 0;
        int tt = 0;
        int ff = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 1 && y[i] == 0) {
                ++tf;
            }
            if (x[i] == 0 && y[i] == 1) {
                ++ft;
            }
            if (x[i] == 1 && y[i] == 1) {
                ++tt;
            }
            if (x[i] != 0 || y[i] != 0) continue;
            ++ff;
        }
        double r = 2 * (tf + ft);
        return r / ((double)(tt + ff) + r / 2.0);
    }
}

