/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression.RegressionTrees.Learning;

import Catalano.Core.ArraysUtil;
import Catalano.Core.Concurrent.MulticoreExecutor;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.MachineLearning.Regression.RegressionTrees.RegressionTree;
import Catalano.Math.Random.Random;
import Catalano.Math.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class RandomForest
implements IRegression,
Serializable {
    private DecisionVariable[] attributes = null;
    private int T;
    private int M;
    private int S;
    private List<RegressionTree> trees;
    private double error;
    private double[] importance;

    public RandomForest() {
        this(100);
    }

    public RandomForest(int T) {
        this(null, 100);
    }

    public RandomForest(int T, int M) {
        this(T, M, 5);
    }

    public RandomForest(int T, int M, int S) {
        this(null, T, M, S);
    }

    public RandomForest(DecisionVariable[] attributes) {
        this(attributes, 100, -1, 5);
    }

    public RandomForest(DecisionVariable[] attributes, int T) {
        this(attributes, T, -1, 5);
    }

    public RandomForest(DecisionVariable[] attributes, int T, int M) {
        this(attributes, T, M, 5);
    }

    public RandomForest(DecisionVariable[] attributes, int T, int M, int S) {
        this.attributes = attributes;
        this.T = T;
        this.M = M;
        this.S = S;
    }

    private int[][] sort(DecisionVariable[] attributes, double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].type != DecisionVariable.Type.Continuous) continue;
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = ArraysUtil.Argsort(a, true);
        }
        return index;
    }

    public double error() {
        return this.error;
    }

    public double[] getImportance() {
        return this.importance;
    }

    public int size() {
        return this.trees.size();
    }

    public void trim(int T) {
        if (T > this.trees.size()) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (T <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + T);
        }
        ArrayList<RegressionTree> model = new ArrayList<RegressionTree>(T);
        for (int i = 0; i < T; ++i) {
            model.add(this.trees.get(i));
        }
        this.trees = model;
    }

    private void BuildModel(DecisionVariable[] attributes, double[][] x, double[] y, int T, int M, int S) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (attributes == null) {
            int p = x[0].length;
            attributes = new DecisionVariable[p];
            for (int i2 = 0; i2 < p; ++i2) {
                attributes[i2] = new DecisionVariable("F" + i2);
            }
        }
        if (M <= 0) {
            M = Math.max(1, x[0].length / 3);
        }
        if (S <= 0) {
            throw new IllegalArgumentException("Invalid minimum leaf node size: " + S);
        }
        int n = x.length;
        double[] prediction = new double[n];
        int[] oob = new int[n];
        int[][] order = this.sort(attributes, x);
        ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>();
        for (int i3 = 0; i3 < T; ++i3) {
            tasks.add(new TrainingTask(attributes, x, y, order, M, S, prediction, oob));
        }
        try {
            this.trees = MulticoreExecutor.run(tasks);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.trees = new ArrayList<RegressionTree>(T);
            for (i = 0; i < T; ++i) {
                this.trees.add(((TrainingTask)tasks.get(i)).call());
            }
        }
        int m = 0;
        for (i = 0; i < n; ++i) {
            if (oob[i] <= 0) continue;
            ++m;
            double pred = prediction[i] / (double)oob[i];
            this.error += Tools.Square(pred - y[i]);
        }
        if (m > 0) {
            this.error = Math.sqrt(this.error / (double)m);
        }
        this.importance = new double[attributes.length];
        for (RegressionTree tree : this.trees) {
            double[] imp = tree.getImportance();
            for (int i4 = 0; i4 < imp.length; ++i4) {
                int n2 = i4;
                this.importance[n2] = this.importance[n2] + imp[i4];
            }
        }
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        this.BuildModel(this.attributes, input, output, this.T, this.M, this.S);
    }

    @Override
    public double Predict(double[] x) {
        double y = 0.0;
        for (RegressionTree tree : this.trees) {
            y += tree.Predict(x);
        }
        return y / (double)this.trees.size();
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    static class TrainingTask
    implements Callable<RegressionTree> {
        DecisionVariable[] attributes;
        double[][] x;
        double[] y;
        int[][] order;
        int M;
        int S;
        double[] prediction;
        int[] oob;

        TrainingTask(DecisionVariable[] attributes, double[][] x, double[] y, int[][] order, int M, int S, double[] prediction, int[] oob) {
            this.attributes = attributes;
            this.x = x;
            this.y = y;
            this.order = order;
            this.M = M;
            this.S = S;
            this.prediction = prediction;
            this.oob = oob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegressionTree call() {
            int n = this.x.length;
            Random random = new Random(Thread.currentThread().getId() * System.currentTimeMillis());
            int[] samples = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = random.nextInt(n);
                samples[n2] = samples[n2] + 1;
            }
            RegressionTree tree = new RegressionTree(this.attributes, this.x, this.y, this.M, this.S, this.order, samples);
            for (int i = 0; i < n; ++i) {
                if (samples[i] != 0) continue;
                double pred = tree.Predict(this.x[i]);
                double[] dArray = this.x[i];
                synchronized (dArray) {
                    int n3 = i;
                    this.prediction[n3] = this.prediction[n3] + pred;
                    int n4 = i;
                    this.oob[n4] = this.oob[n4] + 1;
                    continue;
                }
            }
            return tree;
        }
    }
}

