/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression;

import Catalano.Statistics.Correlations;
import Catalano.Statistics.Tools;

public class RegressionMeasure {
    private final double mae;
    private final double mse;
    private final double rmse;
    private final double r2;
    private final double mda;

    public static double MeanAbsoluteError(double[] actual, double[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("The lenght of the vectors must be the same.");
        }
        double sum = 0.0;
        for (int i = 0; i < actual.length; ++i) {
            sum += Math.abs(actual[i] - predicted[i]);
        }
        return sum /= (double)actual.length;
    }

    public static double MeanSquaredError(double[] actual, double[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("The lenght of the vectors must be the same.");
        }
        double sum = 0.0;
        for (int i = 0; i < actual.length; ++i) {
            sum += Math.pow(actual[i] - predicted[i], 2.0);
        }
        return sum /= (double)actual.length;
    }

    public static double NormalizedMeanSquareError(double[] actual, double[] predicted) {
        double m = Tools.Mean(actual) * Tools.Mean(predicted);
        double sum = 0.0;
        for (int i = 0; i < actual.length; ++i) {
            sum += Math.pow(actual[i] - predicted[i], 2.0) / m;
        }
        return sum / (double)actual.length;
    }

    public static double RootMeanSquaredError(double[] actual, double[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("The lenght of the vectors must be the same.");
        }
        double sum = 0.0;
        for (int i = 0; i < actual.length; ++i) {
            sum += Math.pow(actual[i] - predicted[i], 2.0);
        }
        return Math.sqrt(sum /= (double)actual.length);
    }

    public static double MeanDirectionalAccuracy(double[] actual, double[] predicted) {
        if (actual.length != predicted.length) {
            throw new IllegalArgumentException("The lenght of the vectors must be the same.");
        }
        int sum = 0;
        for (int i = 1; i < actual.length; ++i) {
            double b;
            double a = Math.signum(actual[i] - actual[i - 1]);
            if (a != (b = Math.signum(predicted[i] - predicted[i - 1]))) continue;
            ++sum;
        }
        return (double)sum / (double)actual.length;
    }

    public static double CoefficientOfDetermination(double[] actual, double[] predicted) {
        return Math.pow(Correlations.PearsonCorrelation(actual, predicted), 2.0);
    }

    public double getMeanAbsoluteError() {
        return this.mae;
    }

    public double getMeanSquaredError() {
        return this.mse;
    }

    public double getRootMeanSquaredError() {
        return this.rmse;
    }

    public double getCoefficientOfDetermination() {
        return this.r2;
    }

    public double getMeanDirectionalAccuracy() {
        return this.mda;
    }

    public RegressionMeasure(double mae, double mse, double rmse, double r2, double mda) {
        this.mae = mae;
        this.mse = mse;
        this.rmse = rmse;
        this.r2 = r2;
        this.mda = mda;
    }
}

