/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Performance;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Performance.IRegressionValidation;
import Catalano.MachineLearning.Performance.IValidation;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.MachineLearning.Regression.RegressionMeasure;
import Catalano.Math.Matrix;

public class LeaveOneOutCrossValidation
implements IValidation,
IRegressionValidation {
    @Override
    public double Run(IClassifier classifier, DatasetClassification dataset) {
        return this.Run(classifier, dataset.getInput(), dataset.getOutput());
    }

    @Override
    public double Run(IClassifier classifier, double[][] data, int[] labels) {
        int p = 0;
        for (int i = 0; i < data.length; ++i) {
            double[][] a = Matrix.RemoveRow(data, i);
            int[] b = Matrix.RemoveColumn(labels, i);
            classifier.Learn(a, b);
            if (classifier.Predict(data[i]) != labels[i]) continue;
            ++p;
        }
        return (double)p / (double)data.length;
    }

    @Override
    public RegressionMeasure Run(IRegression regression, DatasetRegression dataset) {
        return this.Run(regression, dataset.getInput(), dataset.getOutput());
    }

    @Override
    public RegressionMeasure Run(IRegression regression, double[][] input, double[] output) {
        double[] predicted = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            double[][] tempInput = Matrix.RemoveRow(input, i);
            double[] tempOutput = Matrix.RemoveColumn(output, i);
            regression.Learn(tempInput, tempOutput);
            predicted[i] = regression.Predict(input[i]);
        }
        double mae = RegressionMeasure.MeanAbsoluteError(output, predicted);
        double mse = RegressionMeasure.MeanSquaredError(output, predicted);
        double rmse = Math.sqrt(mse);
        double coef = RegressionMeasure.CoefficientOfDetermination(output, predicted);
        double mda = RegressionMeasure.MeanDirectionalAccuracy(output, predicted);
        return new RegressionMeasure(mae, mse, rmse, coef, mda);
    }
}

