/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Performance;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Performance.IRegressionValidation;
import Catalano.MachineLearning.Performance.IValidation;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.MachineLearning.Regression.RegressionMeasure;
import Catalano.Math.Matrix;
import java.util.HashMap;
import java.util.Map;

public class HoldoutValidation
implements IValidation,
IRegressionValidation {
    private float p = 0.66f;

    public float getTrainPercentage() {
        return this.p;
    }

    public void setTrainPercetange(float percentage) {
        this.p = Math.max(0.1f, Math.min(1.0f, percentage));
    }

    public HoldoutValidation() {
    }

    public HoldoutValidation(float percentage) {
        this.setTrainPercetange(percentage);
    }

    @Override
    public double Run(IClassifier classifier, DatasetClassification dataset) {
        return this.Run(classifier, dataset.getInput(), dataset.getOutput());
    }

    @Override
    public double Run(IClassifier classifier, double[][] data, int[] labels) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < labels.length; ++i) {
            if (!map.containsKey(labels[i])) {
                map.put(labels[i], 1);
                continue;
            }
            int t = (Integer)map.get(labels[i]) + 1;
            map.put(labels[i], t);
        }
        int[] sizeClass = new int[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            sizeClass[((Integer)entry.getKey()).intValue()] = (int)((float)((Integer)entry.getValue()).intValue() * this.p);
        }
        int size = 0;
        for (int i = 0; i < sizeClass.length; ++i) {
            size += sizeClass[i];
        }
        int[] indexTraining = new int[size];
        int[] indexValidation = new int[data.length - size];
        int idxT = 0;
        int idxV = 0;
        for (int i = 0; i < data.length; ++i) {
            if (sizeClass[labels[i]] > 0) {
                indexTraining[idxT++] = i;
                int n = labels[i];
                sizeClass[n] = sizeClass[n] - 1;
                continue;
            }
            indexValidation[idxV++] = i;
        }
        double[][] train = Matrix.getRows(data, indexTraining);
        int[] labelsTrain = Matrix.getRows(labels, indexTraining);
        classifier.Learn(train, labelsTrain);
        int pos = 0;
        for (int i = 0; i < indexValidation.length; ++i) {
            int v = classifier.Predict(data[indexValidation[i]]);
            if (v != labels[indexValidation[i]]) continue;
            ++pos;
        }
        return (double)pos / (double)indexValidation.length;
    }

    @Override
    public RegressionMeasure Run(IRegression regression, DatasetRegression dataset) {
        return this.Run(regression, dataset.getInput(), dataset.getOutput());
    }

    @Override
    public RegressionMeasure Run(IRegression regression, double[][] input, double[] output) {
        int size = (int)((float)input.length * this.p);
        double[][] tempInput = Matrix.Submatrix(input, 0, size, 0, input[0].length - 1);
        double[] tempOutput = Matrix.getColumns(output, 0, size);
        regression.Learn(tempInput, tempOutput);
        int rest = input.length - size;
        double[] predicted = new double[rest];
        for (int i = 0; i < rest; ++i) {
            predicted[i] = regression.Predict(input[size + i]);
        }
        double[] actual = Matrix.getColumns(output, size, output.length - 1);
        double mae = RegressionMeasure.MeanAbsoluteError(actual, predicted);
        double mse = RegressionMeasure.MeanSquaredError(actual, predicted);
        double rmse = Math.sqrt(mse);
        double coef = RegressionMeasure.CoefficientOfDetermination(actual, predicted);
        double mda = RegressionMeasure.MeanDirectionalAccuracy(actual, predicted);
        return new RegressionMeasure(mae, mse, rmse, coef, mda);
    }
}

