/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureSelection;

import Catalano.MachineLearning.FeatureSelection.IUnsupervisionedFeatureSelection;
import Catalano.Math.Decompositions.EigenvalueDecomposition;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class PrincipalComponentFeatureSelection
implements IUnsupervisionedFeatureSelection {
    private double p;
    private double[] rank;
    private int[] features;

    public double getPercentage() {
        return this.p;
    }

    public void setPercentage(double p) {
        this.p = Math.max(0.0, Math.min(p, 1.0));
    }

    @Override
    public double[] getRank() {
        return this.rank;
    }

    @Override
    public int[] getFeatureIndex() {
        return this.features;
    }

    public PrincipalComponentFeatureSelection() {
        this.p = 0.95;
    }

    public PrincipalComponentFeatureSelection(double percentage) {
        this.setPercentage(percentage);
    }

    @Override
    public void Compute(double[][] input) {
        double[][] mat = Tools.Correlation(input);
        EigenvalueDecomposition evd = new EigenvalueDecomposition(mat);
        double[] eigen = evd.getRealEigenvalues();
        double den = Catalano.Math.Tools.Sum(eigen);
        double sum = 0.0;
        int pos = 1;
        while ((sum += eigen[eigen.length - ++pos]) / den <= this.p) {
        }
        double[] reverse = new double[eigen.length];
        for (int i = 0; i < reverse.length; ++i) {
            reverse[i] = eigen[eigen.length - i - 1];
        }
        this.rank = reverse;
        this.features = Matrix.Indices(0, pos - 1);
    }
}

