/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class Standartization
implements IFeatureScaling {
    private double[][] range;

    public double[][] getRangeNormalization() {
        return this.range;
    }

    public void setRangeNormalization(double[][] range) {
        this.range = range;
    }

    @Override
    public double[][] Apply(double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(result);
        return result;
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(variables, result);
        return result;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        this.range = new double[2][data[0].length];
        for (int i = 0; i < data[0].length; ++i) {
            int idx = 0;
            double[] temp = Matrix.getColumn(data, i);
            double _mean = Tools.Mean(temp);
            double _std = Tools.StandartDeviation(temp, _mean);
            this.range[0][idx] = _mean;
            this.range[1][idx] = _std;
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i] = (data[j][i] - _mean) / _std;
            }
        }
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] attributes, double[][] data) {
        int i;
        int continuous = 0;
        if (attributes == null) {
            attributes = new DecisionVariable[data[0].length + 1];
            for (i = 0; i < attributes.length - 1; ++i) {
                attributes[i] = new DecisionVariable("F" + i, DecisionVariable.Type.Continuous);
            }
            attributes[attributes.length - 1] = new DecisionVariable("Class", DecisionVariable.Type.Discrete);
            continuous += data[0].length;
        } else {
            for (i = 0; i < attributes.length; ++i) {
                if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
                ++continuous;
            }
        }
        this.range = new double[2][continuous];
        for (i = 0; i < data[0].length; ++i) {
            int idx = 0;
            if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
            double[] temp = Matrix.getColumn(data, i);
            double _mean = Tools.Mean(temp);
            double _std = Tools.StandartDeviation(temp, _mean);
            this.range[0][idx] = _mean;
            this.range[1][idx] = _std;
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i] = (data[j][i] - _mean) / _std;
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = (feature[i] - this.range[0][i]) / this.range[1][i];
        }
        return norm;
    }

    @Override
    public double[] Compute(DecisionVariable[] variables, double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            int idx = 0;
            if (variables[i].type != DecisionVariable.Type.Continuous) continue;
            norm[i] = (feature[i] - this.range[0][idx]) / this.range[1][idx];
            ++idx;
        }
        return norm;
    }
}

