/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class Normalization
implements IFeatureScaling {
    private double min = 0.0;
    private double max = 1.0;
    private double[][] range;

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double[][] getRangeNormalization() {
        return this.range;
    }

    public void setRangeNormalization(double[][] range) {
        this.range = range;
    }

    public Normalization() {
    }

    public Normalization(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public double[][] Apply(double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(result);
        return result;
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(variables, result);
        return result;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        this.range = new double[2][data[0].length];
        int idx = 0;
        for (int i = 0; i < data[0].length; ++i) {
            double[] temp = Matrix.getColumn(data, i);
            double _min = Tools.Min(temp);
            double _max = Tools.Max(temp);
            this.range[0][idx] = _min;
            this.range[1][idx] = _max;
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i] = Catalano.Math.Tools.Scale(_min, _max, this.min, this.max, temp[j]);
            }
        }
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] attributes, double[][] data) {
        int i;
        int continuous = 0;
        if (attributes == null) {
            attributes = new DecisionVariable[data[0].length + 1];
            for (i = 0; i < attributes.length - 1; ++i) {
                attributes[i] = new DecisionVariable("F" + i, DecisionVariable.Type.Continuous);
            }
            attributes[attributes.length - 1] = new DecisionVariable("Class", DecisionVariable.Type.Discrete);
            continuous += data[0].length;
        } else {
            for (i = 0; i < attributes.length; ++i) {
                if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
                ++continuous;
            }
        }
        this.range = new double[2][continuous];
        int idx = 0;
        for (int i2 = 0; i2 < data[0].length; ++i2) {
            if (attributes[i2].type != DecisionVariable.Type.Continuous) continue;
            double[] temp = Matrix.getColumn(data, i2);
            double _min = Tools.Min(temp);
            double _max = Tools.Max(temp);
            this.range[0][idx] = _min;
            this.range[1][idx] = _max;
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i2] = Catalano.Math.Tools.Scale(_min, _max, this.min, this.max, temp[j]);
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            double v = Catalano.Math.Tools.Scale(this.range[0][i], this.range[1][i], this.min, this.max, feature[i]);
            v = v > 1.0 ? 1.0 : v;
            norm[i] = v = v < 0.0 ? 0.0 : v;
        }
        return norm;
    }

    @Override
    public double[] Compute(DecisionVariable[] attributes, double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            int idx = 0;
            if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
            double v = Catalano.Math.Tools.Scale(this.range[0][idx], this.range[1][idx], this.min, this.max, feature[i]);
            ++idx;
            v = v > 1.0 ? 1.0 : v;
            norm[i] = v = v < 0.0 ? 0.0 : v;
        }
        return norm;
    }
}

