/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Dataset;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Dataset.IDataset;
import Catalano.MachineLearning.Dataset.StatisticsDataset;
import Catalano.Math.Matrix;
import Catalano.Statistics.DescriptiveStatistics;
import Catalano.Statistics.Tools;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetRegression
implements IDataset<double[][], double[]> {
    private String name;
    private double[][] input;
    private double[] output;
    private DecisionVariable[] attributes;
    private int continuous = 0;
    private int classIndex = -1;

    public String getName() {
        return this.name;
    }

    @Override
    public double[][] getInput() {
        return this.input;
    }

    @Override
    public double[] getOutput() {
        return this.output;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    @Override
    public DecisionVariable[] getDecisionVariables() {
        return Matrix.RemoveColumn(this.attributes, this.classIndex);
    }

    public DecisionVariable[] getAllDecisionVariables() {
        return this.attributes;
    }

    public int getNumberOfInstances() {
        return this.input.length;
    }

    public int getNumberOfAttributes() {
        return this.attributes.length + 1;
    }

    public int getNumberOfContinuous() {
        return this.continuous;
    }

    public int getNumberOfDiscrete() {
        return this.attributes.length - this.continuous;
    }

    public static DatasetRegression FromCSV(String filepath, String name) {
        return DatasetRegression.FromCSV(filepath, name, false);
    }

    public static DatasetRegression FromCSV(String filepath, String name, boolean ignoreAttributeInfo) {
        return DatasetRegression.FromCSV(filepath, name, ignoreAttributeInfo, -1);
    }

    public static DatasetRegression FromCSV(String filepath, String name, boolean ignoreAttributeInfo, int classIndex) {
        double[][] input = null;
        double[] output = null;
        DecisionVariable[] attributes = null;
        int continuous = 0;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-8"));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            if (lines.size() > 0) {
                String[] temp;
                int[] indexes;
                ArrayList lst;
                int start;
                String[] header = null;
                String[] firstInstance = null;
                if (ignoreAttributeInfo) {
                    firstInstance = ((String)lines.get(0)).split(String.valueOf(','));
                    header = new String[firstInstance.length];
                    for (int i = 0; i < header.length - 1; ++i) {
                        header[i] = "F" + i;
                    }
                    header[header.length - 1] = "Class";
                    start = 0;
                } else {
                    header = ((String)lines.get(0)).split(String.valueOf(','));
                    firstInstance = ((String)lines.get(1)).split(String.valueOf(','));
                    start = 1;
                }
                if (classIndex == -1) {
                    classIndex = header.length - 1;
                }
                attributes = new DecisionVariable[header.length];
                HashSet<String> hs = new HashSet<String>();
                int discretes = 0;
                int idx = 0;
                for (int i = 0; i < header.length; ++i) {
                    hs.add(header[i]);
                    if (Catalano.Math.Tools.isNumeric(firstInstance[i])) {
                        attributes[idx] = new DecisionVariable(header[i], DecisionVariable.Type.Continuous);
                        ++continuous;
                    } else {
                        attributes[idx] = new DecisionVariable(header[i], DecisionVariable.Type.Discrete);
                        ++discretes;
                    }
                    ++idx;
                }
                if (hs.size() != attributes.length) {
                    throw new IllegalArgumentException("The column names of attributes must be unique.");
                }
                input = new double[lines.size() - start][attributes.length - 1];
                if (discretes == 0) {
                    lst = null;
                    indexes = null;
                } else {
                    lst = new ArrayList(discretes);
                    for (int i = 0; i < discretes; ++i) {
                        lst.add(new HashMap());
                    }
                    indexes = new int[discretes];
                }
                for (int i = start; i < lines.size(); ++i) {
                    int idxAtt = 0;
                    temp = ((String)lines.get(i)).split(String.valueOf(','));
                    idx = 0;
                    for (int j = 0; j < attributes.length; ++j) {
                        if (j == classIndex) continue;
                        if (attributes[j].type == DecisionVariable.Type.Continuous) {
                            input[i - start][idx++] = Double.valueOf(DatasetRegression.fix(temp[j]));
                            continue;
                        }
                        HashMap map = (HashMap)lst.get(idxAtt);
                        if (!map.containsKey(temp[j])) {
                            int n = idxAtt;
                            int n2 = indexes[n];
                            indexes[n] = n2 + 1;
                            map.put(temp[j], n2);
                        }
                        ++idxAtt;
                        input[i - start][idx++] = ((Integer)map.get(temp[j])).intValue();
                    }
                }
                output = new double[lines.size() - start];
                for (int j = start; j < lines.size(); ++j) {
                    temp = ((String)lines.get(j)).split(String.valueOf(","));
                    output[j - start] = Double.valueOf(temp[classIndex]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DatasetRegression.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetRegression.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new DatasetRegression(name, attributes, input, output, continuous, classIndex);
    }

    private static String fix(String x) {
        String r = "";
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (!Character.isDigit(c) && c != '.' && c != '-' && c != 'E') continue;
            r = r + c;
        }
        return r;
    }

    public DatasetRegression(String filepath) {
        this(filepath, "Unknown");
    }

    public DatasetRegression(String filepath, String name) {
        this(filepath, name, false);
    }

    public DatasetRegression(String filepath, String name, boolean ignoreAttributeInfo) {
        this(filepath, name, ignoreAttributeInfo, -1);
    }

    public DatasetRegression(String filepath, String name, boolean ignoreAttributeInfo, int classIndex) {
        DatasetRegression dataset = DatasetRegression.FromCSV(filepath, name, ignoreAttributeInfo, classIndex);
        this.name = dataset.getName();
        this.attributes = dataset.getAllDecisionVariables();
        this.continuous = dataset.getNumberOfContinuous();
        this.input = dataset.getInput();
        this.output = dataset.getOutput();
        this.classIndex = dataset.getClassIndex();
    }

    public DatasetRegression(String name, double[][] input, double[] output) {
        this(name, input, output, null);
    }

    public DatasetRegression(String name, double[][] input, double[] output, DecisionVariable[] attributes) {
        this.name = name;
        this.input = input;
        this.output = output;
        this.classIndex = input[0].length;
        if (attributes == null) {
            attributes = new DecisionVariable[input[0].length + 1];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = new DecisionVariable("F" + i);
            }
        }
        int c = 0;
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++c;
        }
        this.attributes = attributes;
        this.continuous = c;
    }

    private DatasetRegression(String name, DecisionVariable[] attributes, double[][] input, double[] output, int continuous, int classIndex) {
        this.name = name;
        this.attributes = attributes;
        this.input = input;
        this.output = output;
        this.continuous = continuous;
        this.classIndex = classIndex;
    }

    public double[][] Normalize() {
        return this.Normalize(0.0, 1.0);
    }

    public double[][] Normalize(double min, double max) {
        int continuous = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == this.classIndex || this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++continuous;
        }
        double[][] range = new double[2][continuous];
        int idx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == this.classIndex || this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            double[] temp = Matrix.getColumn(this.input, idx);
            double _min = Tools.Min(temp);
            double _max = Tools.Max(temp);
            range[0][idx] = _min;
            range[1][idx] = _max;
            for (int j = 0; j < temp.length; ++j) {
                this.input[j][idx] = Catalano.Math.Tools.Scale(_min, _max, min, max, temp[j]);
            }
            ++idx;
        }
        return range;
    }

    public void RemoveAttribute(int index) {
        this.input = Matrix.RemoveColumn(this.input, index);
        this.attributes = Matrix.RemoveColumn(this.attributes, index);
    }

    public void RemoveAttributes(int[] indexes) {
        this.input = Matrix.RemoveColumns(this.input, indexes);
        this.attributes = Matrix.RemoveColumns(this.attributes, indexes);
    }

    public void KeepAttributes(int[] indexes) {
        this.input = Matrix.getColumns(this.input, indexes);
        this.attributes = Matrix.getColumns(this.attributes, indexes);
    }

    public DatasetRegression Split(float percentage) {
        return this.Split(percentage, this.name + "_Validation");
    }

    public DatasetRegression Split(float percentage, String name) {
        int n = (int)((float)this.output.length * percentage);
        double[][] trainInput = Matrix.getRows(this.input, Matrix.Indices(0, n));
        double[] trainOutput = Matrix.getColumns(this.output, Matrix.Indices(0, n));
        double[][] valInput = Matrix.RemoveRows(this.input, Matrix.Indices(0, n));
        double[] valOutput = Matrix.RemoveColumns(this.output, Matrix.Indices(0, n));
        this.input = trainInput;
        this.output = trainOutput;
        return new DatasetRegression(name, valInput, valOutput, this.attributes);
    }

    public double[][] Standartize() {
        int continuous = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == this.classIndex || this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++continuous;
        }
        double[][] range = new double[2][continuous];
        int idx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == this.classIndex || this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            double[] temp = Matrix.getColumn(this.input, idx);
            double mean = Tools.Mean(temp);
            double std = Tools.StandartDeviation(temp, mean);
            range[0][idx] = mean;
            range[1][idx] = std;
            for (int j = 0; j < temp.length; ++j) {
                this.input[j][idx] = (this.input[j][idx] - mean) / std;
            }
            ++idx;
        }
        return range;
    }

    @Override
    public StatisticsDataset[] getStatistics() {
        int continuous = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++continuous;
        }
        StatisticsDataset[] stat = new StatisticsDataset[continuous];
        int idx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            boolean isMissing = false;
            double[] temp = Matrix.getColumn(this.input, i);
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (int j = 0; j < temp.length; ++j) {
                if (temp[i] != Double.NaN) continue;
                isMissing = true;
                lst.add(j);
            }
            int[] v = new int[lst.size()];
            for (int j = 0; j < v.length; ++j) {
                v[j] = (Integer)lst.get(j);
            }
            temp = Matrix.RemoveColumns(temp, v);
            double mean = DescriptiveStatistics.Mean(temp);
            double median = DescriptiveStatistics.Median(temp);
            double min = DescriptiveStatistics.Minimum(temp);
            double max = DescriptiveStatistics.Maximum(temp);
            double std = DescriptiveStatistics.StandartDeviation(temp, mean);
            double kurtosis = DescriptiveStatistics.Kurtosis(temp, mean, std);
            double skewness = DescriptiveStatistics.Skewness(temp, mean, std);
            stat[idx++] = new StatisticsDataset(this.attributes[i].name, mean, median, min, max, std, skewness, kurtosis, isMissing);
        }
        return stat;
    }

    public void WriteAsCSV(String filename) {
        this.WriteAsCSV(filename, -1, ',', System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces) {
        this.WriteAsCSV(filename, decimalPlaces, ',', System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter) {
        this.WriteAsCSV(filename, decimalPlaces, delimiter, System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter, String newLine) {
        this.WriteAsCSV(filename, decimalPlaces, delimiter, newLine, true);
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter, String newLine, boolean writeHeader) {
        try {
            int i;
            String dec = "%." + decimalPlaces + "f";
            FileWriter fw = new FileWriter(filename);
            if (this.classIndex < 0) {
                this.classIndex = this.attributes.length - 1;
            }
            if (writeHeader) {
                for (i = 0; i < this.attributes.length; ++i) {
                    if (i == this.classIndex) continue;
                    fw.append(this.attributes[i].name + delimiter);
                }
                fw.append(this.attributes[this.classIndex].name);
                fw.append(newLine);
            }
            for (i = 0; i < this.input.length; ++i) {
                for (int j = 0; j < this.input[0].length; ++j) {
                    if (this.attributes[j].type == DecisionVariable.Type.Continuous) {
                        if (decimalPlaces >= 0) {
                            fw.append(String.format(Locale.US, dec, this.input[i][j]) + delimiter);
                            continue;
                        }
                        fw.append(String.valueOf(this.input[i][j]) + delimiter);
                        continue;
                    }
                    fw.append(String.valueOf(this.input[i][j]) + delimiter);
                }
                fw.append(String.valueOf(this.output[i]) + newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetRegression.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void WriteAsARFF(String filename) {
        this.WriteAsARFF(filename, -1);
    }

    public void WriteAsARFF(String filename, int decimalPlaces) {
        try {
            int i;
            String dec = "%." + decimalPlaces + "f";
            String newLine = System.getProperty("line.separator");
            char delimiter = ',';
            FileWriter fw = new FileWriter(filename);
            fw.append("@RELATION " + this.name);
            fw.append(newLine + newLine);
            for (i = 0; i < this.attributes.length; ++i) {
                if (i == this.classIndex) continue;
                if (this.attributes[i].type == DecisionVariable.Type.Continuous) {
                    fw.append("@ATTRIBUTE " + this.attributes[i].name.replace(" ", "_") + " NUMERIC");
                    fw.append(newLine);
                    continue;
                }
                String nominal = "{";
                int max = (int)Matrix.Max(Matrix.getColumn(this.input, i));
                for (int j = 0; j < max; ++j) {
                    nominal = nominal + j + ", ";
                }
                nominal = nominal + max + "}";
                fw.append("@ATTRIBUTE " + this.attributes[i].name.replace(" ", "_") + nominal);
                fw.append(newLine);
            }
            fw.append("@ATTRIBUTE " + this.attributes[this.classIndex].name.replace(" ", "_") + " NUMERIC");
            fw.append(newLine);
            fw.append(newLine);
            fw.append("@DATA" + newLine);
            for (i = 0; i < this.input.length; ++i) {
                for (int j = 0; j < this.input[0].length; ++j) {
                    if (decimalPlaces >= 0) {
                        fw.append(String.format(Locale.US, dec, this.input[i][j]) + delimiter);
                        continue;
                    }
                    fw.append(String.valueOf(this.input[i][j]) + delimiter);
                }
                fw.append(String.valueOf(this.output[i]) + newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetRegression.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setInput(double[][] input, DecisionVariable[] variables) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

