/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Clustering;

import Catalano.Math.Distances.Distance;
import Catalano.Math.Distances.IDivergence;
import Catalano.Math.Tools;
import java.io.Serializable;
import java.util.Arrays;

public abstract class PartitionClustering<T>
implements Serializable {
    int k;
    int[] y;
    int[] size;

    PartitionClustering() {
    }

    public int getNumClusters() {
        return this.k;
    }

    public int[] getClusterLabel() {
        return this.y;
    }

    public int[] getClusterSize() {
        return this.size;
    }

    static double squaredDistance(double[] x, double[] y) {
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            ++m;
            double d = x[i] - y[i];
            dist += d * d;
        }
        dist = m == 0 ? Double.MAX_VALUE : (double)n * dist / (double)m;
        return dist;
    }

    static int[] seed(double[][] data, int k, DistanceMethod method) {
        int i;
        int n = data.length;
        int[] y = new int[n];
        double[] centroid = data[Tools.Random().nextInt(n)];
        double[] d = new double[n];
        for (i = 0; i < n; ++i) {
            d[i] = Double.MAX_VALUE;
        }
        for (int j = 1; j < k; ++j) {
            int index;
            for (int i2 = 0; i2 < n; ++i2) {
                double dist = 0.0;
                switch (method) {
                    case EUCLIDEAN: {
                        dist = Distance.SquaredEuclidean(data[i2], centroid);
                        break;
                    }
                    case EUCLIDEAN_MISSING_VALUES: {
                        dist = PartitionClustering.squaredDistance(data[i2], centroid);
                        break;
                    }
                    case JENSEN_SHANNON_DIVERGENCE: {
                        dist = Distance.JensenShannonDivergence(data[i2], centroid);
                    }
                }
                if (!(dist < d[i2])) continue;
                d[i2] = dist;
                y[i2] = j - 1;
            }
            double cutoff = Math.random() * Tools.Sum(d);
            double cost = 0.0;
            for (index = 0; index < n && !((cost += d[index]) >= cutoff); ++index) {
            }
            centroid = data[index];
        }
        for (i = 0; i < n; ++i) {
            double dist = 0.0;
            switch (method) {
                case EUCLIDEAN: {
                    dist = Distance.SquaredEuclidean(data[i], centroid);
                    break;
                }
                case EUCLIDEAN_MISSING_VALUES: {
                    dist = PartitionClustering.squaredDistance(data[i], centroid);
                    break;
                }
                case JENSEN_SHANNON_DIVERGENCE: {
                    dist = Distance.JensenShannonDivergence(data[i], centroid);
                }
            }
            if (!(dist < d[i])) continue;
            d[i] = dist;
            y[i] = k - 1;
        }
        return y;
    }

    static <T> double seed(IDivergence<T> distance, T[] data, T[] medoids, int[] y, double[] d) {
        int n = data.length;
        int k = medoids.length;
        T medoid = data[Tools.Random().nextInt(n)];
        medoids[0] = medoid;
        Arrays.fill(d, Double.MAX_VALUE);
        for (int j = 1; j < k; ++j) {
            int index;
            for (int i = 0; i < n; ++i) {
                double dist = distance.Compute(data[i], medoid);
                if (!(dist < d[i])) continue;
                d[i] = dist;
                y[i] = j - 1;
            }
            double cutoff = Math.random() * Tools.Sum(d);
            double cost = 0.0;
            for (index = 0; index < n && !((cost += d[index]) >= cutoff); ++index) {
            }
            medoid = data[index];
            medoids[j] = medoid;
        }
        for (int i = 0; i < n; ++i) {
            double dist = distance.Compute(data[i], medoid);
            if (!(dist < d[i])) continue;
            d[i] = dist;
            y[i] = k - 1;
        }
        double distortion = 0.0;
        for (int i = 0; i < n; ++i) {
            distortion += d[i];
        }
        return distortion;
    }

    static enum DistanceMethod {
        EUCLIDEAN,
        EUCLIDEAN_MISSING_VALUES,
        JENSEN_SHANNON_DIVERGENCE;

    }
}

