/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Classification.SVM;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class SupportVectorMachine
implements IClassifier,
Serializable {
    private IMercerKernel kernel;
    private double c;
    private double cn;
    private SVM<double[]> svm;

    public SupportVectorMachine(IMercerKernel kernel, double c) {
        this(kernel, c, c);
    }

    public SupportVectorMachine(IMercerKernel kernel, double c, double cn) {
        this.kernel = kernel;
        this.c = c;
        this.cn = cn;
        this.Initialize(kernel, c, cn);
    }

    private void Initialize(IMercerKernel kernel, double c, double cn) {
        this.svm = new SVM(kernel, c, cn);
    }

    @Override
    public void Learn(DatasetClassification dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, int[] output) {
        this.Initialize(this.kernel, this.c, this.cn);
        this.svm.Learn((T[])input, output);
    }

    public void Learn(double[] input, int output) {
        this.svm.Learn(input, output);
    }

    @Override
    public int Predict(double[] feature) {
        return this.svm.Predict(feature);
    }

    @Override
    public IClassifier clone() {
        try {
            return (IClassifier)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    public void Finish() {
        this.svm.Finish();
    }
}

