/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.MachineLearning.Classification.SVM;
import Catalano.Math.SparseArray;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class SparseMulticlassSupportVectorMachine
implements Serializable {
    private IMercerKernel kernel;
    private double c;
    private int numberOfClasses;
    private SVM.Strategy strategy;
    private SVM<SparseArray> svm;

    public SparseMulticlassSupportVectorMachine(IMercerKernel kernel, double c, int numberOfClasses) {
        this(kernel, c, numberOfClasses, SVM.Strategy.ONE_VS_ONE);
    }

    public SparseMulticlassSupportVectorMachine(IMercerKernel kernel, double c, int numberOfClasses, SVM.Strategy strategy) {
        this.kernel = kernel;
        this.c = c;
        this.numberOfClasses = numberOfClasses;
        this.strategy = strategy;
        this.Initialize(kernel, c, numberOfClasses, strategy);
    }

    public SparseMulticlassSupportVectorMachine(IMercerKernel kernel, double c, double[] weight) {
        this(kernel, c, weight, SVM.Strategy.ONE_VS_ONE);
    }

    public SparseMulticlassSupportVectorMachine(IMercerKernel kernel, double c, double[] weight, SVM.Strategy strategy) {
        this.kernel = kernel;
        this.c = c;
        this.numberOfClasses = weight.length;
        this.strategy = strategy;
        this.Initialize(kernel, c, weight, strategy);
    }

    private void Initialize(IMercerKernel kernel, double c, int nClasses, SVM.Strategy strategy) {
        this.svm = new SVM(kernel, c, nClasses, strategy);
    }

    private void Initialize(IMercerKernel kernel, double c, double[] weight, SVM.Strategy strategy) {
        this.svm = new SVM(kernel, c, weight, strategy);
    }

    public void Learn(SparseArray[] input, int[] output) {
        this.Initialize(this.kernel, this.c, this.numberOfClasses, this.strategy);
        this.svm.Learn((SparseArray[])input, output);
    }

    public void Learn(SparseArray input, int output) {
        this.svm.Learn(input, output);
    }

    public int Predict(SparseArray feature) {
        return this.svm.Predict(feature);
    }

    public void Finish() {
        this.svm.Finish();
    }
}

