/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Codebook;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.MachineLearning.FeatureScaling.Normalization;
import java.io.Serializable;

public class ClassifierPipeline
implements Serializable {
    private final IClassifier classifier;
    private final IFeatureScaling featureScale;
    private DecisionVariable[] variables;
    private Codebook codebook;

    public IClassifier getClassifier() {
        return this.classifier;
    }

    public IFeatureScaling getFeatureScale() {
        return this.featureScale;
    }

    public DecisionVariable[] getVariables() {
        return this.variables;
    }

    public Codebook getCodebook() {
        return this.codebook;
    }

    public ClassifierPipeline(IClassifier classifier) {
        this(classifier, new Normalization());
    }

    public ClassifierPipeline(IClassifier classifier, IFeatureScaling scale) {
        this(classifier, scale, null);
    }

    public ClassifierPipeline(IClassifier classifier, IFeatureScaling scale, DecisionVariable[] variables) {
        this(classifier, scale, variables, null);
    }

    public ClassifierPipeline(IClassifier classifier, IFeatureScaling scale, DecisionVariable[] variables, Codebook codebook) {
        this.classifier = classifier;
        this.featureScale = scale;
        this.variables = variables;
        this.codebook = codebook;
    }

    public int Predict(double[] sample) {
        if (this.variables == null) {
            if (this.featureScale != null) {
                double[] v = this.featureScale.Compute(sample);
                return this.classifier.Predict(v);
            }
            return this.classifier.Predict(sample);
        }
        if (this.featureScale != null) {
            double[] v = this.featureScale.Compute(this.variables, sample);
            return this.classifier.Predict(v);
        }
        return this.classifier.Predict(sample);
    }

    public String Translate(int code) {
        return this.codebook.Translate(code);
    }
}

