/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Math.ComplexNumber;
import java.util.ArrayList;

public final class ZernikeMoments {
    private ZernikeMoments() {
    }

    public static double RadialPolynomial(int n, int m_in, double x, double y) {
        int m = Math.abs(m_in);
        if ((n - m) % 2 != 0) {
            return 0.0;
        }
        double res = 0.0;
        if (x * x + y * y <= 1.0) {
            int sign = 1;
            int a = ZernikeMoments.Factorial(n);
            int b = 1;
            int c = ZernikeMoments.Factorial((n + m) / 2);
            int d = ZernikeMoments.Factorial((n - m) / 2);
            for (int s = 0; s <= (n - m) / 2; ++s) {
                res += (double)sign * ((double)a * 1.0 / (double)(b * c * d)) * Math.pow(x * x + y * y, (double)n / 2.0 - (double)s);
                if (s >= (n - m) / 2) continue;
                sign = -sign;
                a /= n - s;
                b *= s + 1;
                c /= (n + m) / 2 - s;
                d /= (n - m) / 2 - s;
            }
        }
        return res;
    }

    public static ComplexNumber ZernikeBasisFunction(int n, int m, double x, double y) {
        if (x * x + y * y > 1.0) {
            return new ComplexNumber(0.0, 0.0);
        }
        double r = ZernikeMoments.RadialPolynomial(n, m, x, y);
        double arg = (double)m * Math.atan2(y, x);
        double real = r * Math.cos(arg);
        double imag = r * Math.sin(arg);
        return new ComplexNumber(real, imag);
    }

    public static ComplexNumber ZernikeMoments(double[] x, double[] y, int nPoints, int n, int m) {
        int diff = n - Math.abs(m);
        if (n < 0 || Math.abs(m) > n || diff % 2 != 0) {
            throw new IllegalArgumentException("zer_mom: n=" + n + ", m=" + m + ", n-|m|=" + diff);
        }
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (int i = 0; i < nPoints; ++i) {
            xmin = Math.min(xmin, x[i]);
            xmax = Math.max(xmax, x[i]);
            ymin = Math.min(ymin, y[i]);
            ymax = Math.max(ymax, y[i]);
        }
        double w = xmax - xmin;
        double h = ymax - ymin;
        double cx = xmin + w / 2.0;
        double cy = ymin + h / 2.0;
        return ZernikeMoments.ZernikeMoments(x, y, nPoints, w, h, cx, cy, n, m);
    }

    public static ComplexNumber ZernikeMoments(double[] x, double[] y, int nPoints, double w, double h, double cx, double cy, int n, int m) {
        int diff = n - Math.abs(m);
        if (n < 0 || Math.abs(m) > n || diff % 2 != 0) {
            throw new IllegalArgumentException("zer_mom: n=" + n + ", m=" + m + ", n-|m|=" + diff);
        }
        double i_0 = cx;
        double j_0 = cy;
        double radius = w / 2.0;
        double i_scale = Math.sqrt(2.0) * radius;
        radius = h / 2.0;
        double j_scale = Math.sqrt(2.0) * radius;
        ComplexNumber res = new ComplexNumber();
        for (int i = 0; i < nPoints; ++i) {
            double X = (x[i] - i_0) / i_scale;
            double Y = (y[i] - j_0) / j_scale;
            if (!(X * X + Y * Y <= 1.0)) continue;
            ComplexNumber v = ZernikeMoments.ZernikeBasisFunction(n, m, X, Y);
            res.real += v.real;
            res.imaginary += v.imaginary;
        }
        res.real = res.real * (double)(n + 1) / Math.PI;
        res.imaginary = res.imaginary * (double)(n + 1) / Math.PI;
        return res;
    }

    public static ComplexNumber[] ZernikeMoments(int order, double[] x, double[] y, int npoints) {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            xmin = Math.min(xmin, x[i]);
            xmax = Math.max(xmax, x[i]);
            ymin = Math.min(ymin, y[i]);
            ymax = Math.max(ymax, y[i]);
        }
        double ww = xmax - xmin;
        double hh = ymax - ymin;
        double cx = xmin + ww / 2.0;
        double cy = ymin + hh / 2.0;
        return ZernikeMoments.ZernikeMoments(order, x, y, npoints, ww, hh, cx, cy);
    }

    public static ComplexNumber[] ZernikeMoments(int order, double[] x, double[] y, int npoints, double w, double h, double cx, double cy) {
        ArrayList<ComplexNumber> list = new ArrayList<ComplexNumber>(order);
        int ct = 0;
        for (int n = 0; n <= order; ++n) {
            for (int m = 0; m <= n; ++m) {
                if ((n - Math.abs(m)) % 2 != 0) continue;
                ComplexNumber v = ZernikeMoments.ZernikeMoments(x, y, npoints, w, h, cx, cy, n, m);
                list.add(ct, v);
                list.add(v);
                ++ct;
            }
        }
        ComplexNumber[] mmts = new ComplexNumber[ct];
        for (int i = 0; i < ct; ++i) {
            mmts[i] = (ComplexNumber)list.get(i);
        }
        return mmts;
    }

    private static int Factorial(int n) {
        int x = 1;
        for (int i = 2; i <= n; ++i) {
            x *= i;
        }
        return x;
    }
}

