/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.DistanceTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UltimateErodedPoints {
    private final int[] DIR_X_OFFSET = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] DIR_Y_OFFSET = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    private int[] dirOffset;
    private final float SQRT2 = 1.4142135f;
    private float tolerance = 0.5f;
    private int intEncodeXMask;

    public List<IntPoint> Process(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("UED only works in grayscale images.");
        }
        DistanceTransform dt = new DistanceTransform();
        float[][] distance = dt.Compute(fastBitmap);
        float[] distance1D = new float[distance.length * distance[0].length];
        int p = 0;
        for (int i = 0; i < fastBitmap.getHeight(); ++i) {
            for (int j = 0; j < fastBitmap.getWidth(); ++j) {
                distance1D[p++] = distance[i][j];
            }
        }
        this.makeDirectionOffsets(distance[0].length);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        FastBitmap back = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        long[] maxPoints = this.getSortedMaxPoints(distance, distance1D, back, 0.0f, dt.getMaximumDistance(), -808080.0);
        float maxSortingError = 0.7778175f;
        return this.analyseAndMarkMaxima(distance1D, back, maxPoints, this.tolerance, maxSortingError);
    }

    private void makeDirectionOffsets(int width) {
        int shift = 0;
        int mult = 1;
        do {
            ++shift;
        } while ((mult *= 2) < width);
        this.intEncodeXMask = mult - 1;
        this.dirOffset = new int[]{-width, -width + 1, 1, width + 1, width, width - 1, -1, -width - 1};
    }

    private long[] getSortedMaxPoints(float[][] distance, float[] distance1D, FastBitmap back, float globalMin, float globalMax, double threshold) {
        byte[] types = back.getGrayData();
        int nMax = 0;
        for (int y = 0; y < distance.length; ++y) {
            int x = 0;
            int i = x + y * distance[0].length;
            while (x < distance[0].length) {
                float v = distance[y][x];
                float vTrue = this.trueEdmHeight(x, y, distance1D, distance[0].length, distance.length);
                if (v != globalMin && x != 0 && x != distance[0].length - 1 && y != 0 && y != distance.length - 1 && !((double)v < threshold)) {
                    boolean isMax = true;
                    boolean isInner = y != 0 && y != distance.length - 1 && x != 0 && x != distance[0].length - 1;
                    for (int d = 0; d < 8; ++d) {
                        if (!isInner && !this.isWithin(x, y, d, distance[0].length, distance.length)) continue;
                        float vNeighbor = distance[y + this.DIR_Y_OFFSET[d]][x + this.DIR_X_OFFSET[d]];
                        float vNeighborTrue = this.trueEdmHeight(x + this.DIR_X_OFFSET[d], y + this.DIR_Y_OFFSET[d], distance1D, distance[0].length, distance.length);
                        if (!(vNeighbor > v) || !(vNeighborTrue > vTrue)) continue;
                        isMax = false;
                        break;
                    }
                    if (isMax) {
                        types[i] = 1;
                        ++nMax;
                    }
                }
                ++x;
                ++i;
            }
        }
        float vFactor = (float)(2.0E9 / (double)(globalMax - globalMin));
        long[] maxPoints = new long[nMax];
        int iMax = 0;
        for (int y = 0; y < distance.length; ++y) {
            int x = 0;
            int pp = x + y * distance[0].length;
            while (x < distance[0].length) {
                if (types[pp] == 1) {
                    float fValue = this.trueEdmHeight(x, y, distance1D, distance[0].length, distance.length);
                    int iValue = (int)((fValue - globalMin) * vFactor);
                    maxPoints[iMax++] = (long)iValue << 32 | (long)pp;
                }
                ++x;
                ++pp;
            }
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    private boolean isWithin(int x, int y, int direction, int width, int height) {
        int xmax = width - 1;
        int ymax = height - 1;
        switch (direction) {
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: {
                return x > 0 && y > 0;
            }
        }
        return false;
    }

    private List<IntPoint> analyseAndMarkMaxima(float[] edmPixels, FastBitmap back, long[] maxPoints, float tolerance, float maxSortingError) {
        ArrayList<IntPoint> uep = new ArrayList<IntPoint>();
        int width = back.getWidth();
        int height = back.getHeight();
        byte[] types = back.getGrayData();
        int nMax = maxPoints.length;
        int[] pList = new int[width * height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            boolean sortingError;
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 4) != 0) continue;
            int x0 = offset0 % width;
            int y0 = offset0 / width;
            float v0 = this.trueEdmHeight(x0, y0, edmPixels, width, height);
            do {
                pList[0] = offset0;
                int n = offset0;
                types[n] = (byte)(types[n] | 0x12);
                int listLen = 1;
                int listI = 0;
                sortingError = false;
                boolean maxPossible = true;
                double xEqual = x0;
                double yEqual = y0;
                int nEqual = 1;
                block2: do {
                    int offset = pList[listI];
                    int x = offset % width;
                    int y = offset / width;
                    boolean isInner = y != 0 && y != height - 1 && x != 0 && x != width - 1;
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!isInner && !this.isWithin(x, y, d, width, height) || (types[offset2] & 2) != 0 || edmPixels[offset2] <= 0.0f) continue;
                        if ((types[offset2] & 4) != 0) {
                            maxPossible = false;
                            continue block2;
                        }
                        int x2 = x + this.DIR_X_OFFSET[d];
                        int y2 = y + this.DIR_Y_OFFSET[d];
                        float v2 = this.trueEdmHeight(x2, y2, edmPixels, width, height);
                        if (v2 > v0 + maxSortingError) {
                            maxPossible = false;
                            continue block2;
                        }
                        if (!(v2 >= v0 - tolerance)) continue;
                        if (v2 > v0) {
                            sortingError = true;
                            offset0 = offset2;
                            v0 = v2;
                            x0 = x2;
                            y0 = y2;
                        }
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                        if (v2 != v0) continue;
                        int n3 = offset2;
                        types[n3] = (byte)(types[n3] | 0x10);
                        xEqual += (double)x2;
                        yEqual += (double)y2;
                        ++nEqual;
                    }
                } while (++listI < listLen);
                if (sortingError) {
                    for (listI = 0; listI < listLen; ++listI) {
                        types[pList[listI]] = 0;
                    }
                } else {
                    int offset;
                    int resetMask = ~(maxPossible ? 2 : 18);
                    xEqual /= (double)nEqual;
                    yEqual /= (double)nEqual;
                    double minDist2 = 1.0E20;
                    int nearestI = 0;
                    for (listI = 0; listI < listLen; ++listI) {
                        double dist2;
                        offset = pList[listI];
                        int x = offset % width;
                        int y = offset / width;
                        int n4 = offset;
                        types[n4] = (byte)(types[n4] & resetMask);
                        int n5 = offset;
                        types[n5] = (byte)(types[n5] | 4);
                        if (!maxPossible) continue;
                        int n6 = offset;
                        types[n6] = (byte)(types[n6] | 8);
                        if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)x) * (xEqual - (double)x) + (yEqual - (double)y) * (yEqual - (double)y)) < minDist2)) continue;
                        minDist2 = dist2;
                        nearestI = listI;
                    }
                    if (!maxPossible) continue;
                    offset = pList[nearestI];
                    uep.add(new IntPoint(offset / width, offset % width));
                    int n7 = offset;
                    types[n7] = (byte)(types[n7] | 0x20);
                }
            } while (sortingError);
        }
        return uep;
    }

    private float trueEdmHeight(int x, int y, float[] pixels, int width, int height) {
        int xmax = width - 1;
        int ymax = height - 1;
        int offset = x + y * width;
        float v = pixels[offset];
        if (x == 0 || y == 0 || x == xmax || y == ymax || v == 0.0f) {
            return v;
        }
        float trueH = v + 0.70710677f;
        boolean ridgeOrMax = false;
        for (int d = 0; d < 4; ++d) {
            float h;
            int d2 = (d + 4) % 8;
            float v1 = pixels[offset + this.dirOffset[d]];
            float v2 = pixels[offset + this.dirOffset[d2]];
            if (v >= v1 && v >= v2) {
                ridgeOrMax = true;
                h = (v1 + v2) / 2.0f;
            } else {
                h = Math.min(v1, v2);
            }
            h += d % 2 == 0 ? 1.0f : 1.4142135f;
            if (!(trueH > h)) continue;
            trueH = h;
        }
        if (!ridgeOrMax) {
            trueH = v;
        }
        return trueH;
    }
}

