/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Math.Geometry.PointsCloud;
import java.util.ArrayList;
import java.util.List;

public class QuadrilateralFinder {
    public List<IntPoint> ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            List<IntPoint> points = new ArrayList<IntPoint>();
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            block0: for (int y = 0; y < height; ++y) {
                int x;
                boolean lineIsEmpty = true;
                for (x = 0; x < width; ++x) {
                    if (fastBitmap.getGray(y, x) == 0) continue;
                    points.add(new IntPoint(x, y));
                    lineIsEmpty = false;
                    break;
                }
                if (lineIsEmpty) continue;
                for (x = width - 1; x >= 0; --x) {
                    if (fastBitmap.getGray(y, x) == 0) continue;
                    points.add(new IntPoint(x, y));
                    continue block0;
                }
            }
            points = PointsCloud.FindQuadrilateralCorners(points);
            if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
                for (IntPoint p : points) {
                    p.Swap();
                }
            }
            return points;
        }
        throw new IllegalArgumentException("Only works in grayscale images.");
    }
}

