/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageMoments;
import Catalano.Math.Matrix;

public class OrthogonalVariantMoments {
    public double[] Compute(FastBitmap fastBitmap) {
        int j;
        int i;
        int j2;
        int i2;
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Orthogonal Variant Moments only works in grayscale images.");
        }
        double[] moments = new double[5];
        moments[0] = ImageMoments.getRawMoment(fastBitmap, 0, 0);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double box = width * height;
        double[][] diff = new double[height - 1][width];
        for (int i3 = 0; i3 < height - 1; ++i3) {
            for (int j3 = 0; j3 < width; ++j3) {
                diff[i3][j3] = fastBitmap.getGray(i3 + 1, j3) - fastBitmap.getGray(i3, j3);
            }
        }
        double m = Matrix.SumAbs(diff);
        double ly = 0.0;
        for (int i4 = 0; i4 < diff.length; ++i4) {
            for (int j4 = 0; j4 < diff[0].length; ++j4) {
                ly += Math.sqrt(diff[i4][j4] * diff[i4][j4] + 1.0);
            }
        }
        moments[2] = (ly + 3.0) / box;
        double den = m / 8.0 + 0.1;
        double dsum = 1.0;
        for (i2 = 0; i2 < diff.length; ++i2) {
            for (j2 = 0; j2 < diff[0].length; ++j2) {
                dsum += Math.abs(diff[i2][j2]) * (double)(i2 + 1);
            }
        }
        moments[4] = (dsum + 1.0) / den;
        diff = new double[height][width - 1];
        for (i2 = 0; i2 < diff.length; ++i2) {
            for (j2 = 0; j2 < diff[0].length; ++j2) {
                diff[i2][j2] = fastBitmap.getGray(i2, j2 + 1) - fastBitmap.getGray(i2, j2);
            }
        }
        m = Matrix.SumAbs(diff);
        double lx = 0.0;
        for (i = 0; i < diff.length; ++i) {
            for (j = 0; j < diff[0].length; ++j) {
                lx += Math.sqrt(diff[i][j] * diff[i][j] + 1.0);
            }
        }
        moments[1] = (lx + 3.0) / box;
        den = m / 4.5 + 0.1;
        dsum = 1.0;
        for (i = 0; i < diff.length; ++i) {
            for (j = 0; j < diff[0].length; ++j) {
                dsum += Math.abs(diff[i][j]) * (double)(j + 1);
            }
        }
        moments[3] = (dsum + 1.0) / den;
        return moments;
    }
}

