/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;

public class IntegralImage {
    protected int[][] integralImage = null;
    private int width;
    private int height;

    public IntegralImage(FastBitmap fastBitmap) {
        this(fastBitmap, 1);
    }

    public IntegralImage(FastBitmap fastBitmap, int power) {
        this.width = fastBitmap.getWidth();
        this.height = fastBitmap.getHeight();
        this.Process(fastBitmap, power);
    }

    protected IntegralImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.integralImage = new int[height + 1][width + 1];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[][] getInternalData() {
        return this.integralImage;
    }

    public int getInternalData(int x, int y) {
        return this.integralImage[x][y];
    }

    public static IntegralImage FromFastBitmap(FastBitmap fastBitmap) {
        return IntegralImage.FromFastBitmap(fastBitmap, 1);
    }

    public static IntegralImage FromFastBitmap(FastBitmap fastBitmap, int power) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        IntegralImage im = new IntegralImage(width, height);
        int[][] integralImage = im.integralImage;
        for (int i = 1; i <= height; ++i) {
            int rowSum = 0;
            for (int j = 1; j <= width; ++j) {
                rowSum = (int)((double)rowSum + Math.pow(fastBitmap.getGray(i - 1, j - 1), power));
                integralImage[i][j] = rowSum + integralImage[i - 1][j];
            }
        }
        return im;
    }

    private void Process(FastBitmap fastBitmap, int power) {
        if (!fastBitmap.isGrayscale()) {
            try {
                throw new Exception("IntegralImage works only with Grayscale images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.integralImage = new int[this.height + 1][this.width + 1];
        for (int x = 1; x < this.height + 1; ++x) {
            int rowSum = 0;
            for (int y = 1; y < this.width + 1; ++y) {
                rowSum = (int)((double)rowSum + Math.pow(fastBitmap.getGray(x - 1, y - 1), power));
                this.integralImage[x][y] = rowSum + this.integralImage[x - 1][y];
            }
        }
    }

    public int getRectangleSum(int x1, int y1, int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x1 >= this.height || y1 >= this.width) {
            return 0;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        ++y2;
        if (++x2 > this.height) {
            x2 = this.height;
        }
        if (y2 > this.width) {
            y2 = this.width;
        }
        return this.integralImage[x2][y2] + this.integralImage[x1][y1] - this.integralImage[x1][y2] - this.integralImage[x2][y2];
    }

    public int getRectangleSum(int x, int y, int radius) {
        return this.getRectangleSum(x - radius, y - radius, x + radius, y + radius);
    }

    public int getHarrXWavelet(int x, int y, int radius) {
        int y1 = y - radius;
        int y2 = y + radius - 1;
        int a = this.getRectangleSum(x, y1, x + radius - 1, y2);
        int b = this.getRectangleSum(x - radius, y1, x - 1, y2);
        return a - b;
    }

    public int getHaarYWavelet(int x, int y, int radius) {
        int x1 = x - radius;
        int x2 = x + radius - 1;
        float a = this.getRectangleSum(x1, y, x2, y + radius - 1);
        float b = this.getRectangleSum(x1, y - radius, x2, y - 1);
        return (int)(a - b);
    }

    public float getRectangleMean(int x1, int y1, int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x1 >= this.height || y1 >= this.width) {
            return 0.0f;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        ++y2;
        if (++x2 > this.height) {
            x2 = this.height;
        }
        if (y2 > this.width) {
            y2 = this.width;
        }
        return (float)((double)(this.integralImage[x2][y2] + this.integralImage[x1][y1] - this.integralImage[x1][y2] - this.integralImage[x2][y1]) / (double)((x2 - x1) * (y2 - y1)));
    }

    public float getRectangleMean(int x, int y, int radius) {
        return this.getRectangleMean(x - radius, y - radius, x + radius, y + radius);
    }

    public int getRectangleSumUnsafe(int x1, int y1, int x2, int y2) {
        return this.integralImage[++x2][++y2] + this.integralImage[x1][y1] - this.integralImage[x2][y1] - this.integralImage[x1][y2];
    }

    public int getRectangleSumUnsafe(int x, int y, int radius) {
        return this.getRectangleSumUnsafe(x - radius, y - radius, x + radius, y + radius);
    }

    public float getRectangleMeanUnsafe(int x1, int y1, int x2, int y2) {
        return (float)((double)(this.integralImage[++x2][++y2] + this.integralImage[x1][y1] - this.integralImage[x1][y2] - this.integralImage[x2][y1]) / (double)((x2 - x1) * (y2 - y1)));
    }

    public float getRectangleMeanUnsafe(int x, int y, int radius) {
        return this.getRectangleMeanUnsafe(x - radius, y - radius, x + radius, y + radius);
    }
}

