/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.DoublePoint;
import Catalano.Imaging.FastBitmap;

public final class ImageMoments {
    private ImageMoments() {
    }

    public static double getRawMoment(FastBitmap fastBitmap, int p, int q) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double m = 0.0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                m += Math.pow(i, p) * Math.pow(j, q) * (double)fastBitmap.getGray(i, j);
            }
        }
        return m;
    }

    public static double getCentralMoment(FastBitmap fastBitmap, int p, int q) {
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap);
        return ImageMoments.getCentralMoment(fastBitmap, p, q, centroid);
    }

    public static double getCentralMoment(FastBitmap fastBitmap, int p, int q, DoublePoint centroid) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double mc = 0.0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                mc += Math.pow((double)i - centroid.x, p) * Math.pow((double)j - centroid.y, q) * (double)fastBitmap.getGray(i, j);
            }
        }
        return mc;
    }

    public static DoublePoint getCentroid(FastBitmap fastBitmap) {
        double m00 = ImageMoments.getRawMoment(fastBitmap, 0, 0);
        return ImageMoments.getCentroid(fastBitmap, m00);
    }

    public static DoublePoint getCentroid(FastBitmap fastBitmap, double m00) {
        double m10 = ImageMoments.getRawMoment(fastBitmap, 1, 0);
        double m01 = ImageMoments.getRawMoment(fastBitmap, 0, 1);
        double x0 = m10 / m00;
        double y0 = m01 / m00;
        return new DoublePoint(x0, y0);
    }

    public static double getCovarianceXY(FastBitmap fastBitmap, int p, int q) {
        double mc00 = ImageMoments.getCentralMoment(fastBitmap, 0, 0);
        double mc11 = ImageMoments.getCentralMoment(fastBitmap, 1, 1);
        return mc11 / mc00;
    }

    public static double getVarianceX(FastBitmap fastBitmap, int p, int q) {
        double mc00 = ImageMoments.getCentralMoment(fastBitmap, 0, 0);
        double mc20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0);
        return mc20 / mc00;
    }

    public static double getVarianceY(FastBitmap fastBitmap, int p, int q) {
        double mc00 = ImageMoments.getCentralMoment(fastBitmap, 0, 0);
        double mc02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2);
        return mc02 / mc00;
    }

    public static double getOrientation(FastBitmap fastBitmap) {
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap);
        double cm11 = ImageMoments.getCentralMoment(fastBitmap, 1, 1, centroid);
        double cm20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0, centroid);
        double cm02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2, centroid);
        return 0.5 * Math.atan2(cm20 - cm02, 2.0 * cm11);
    }

    public static DoublePoint getProjectionSkewness(FastBitmap fastBitmap) {
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap);
        return ImageMoments.getProjectionSkewness(fastBitmap, centroid);
    }

    public static DoublePoint getProjectionSkewness(FastBitmap fastBitmap, DoublePoint centroid) {
        double u30 = ImageMoments.getCentralMoment(fastBitmap, 3, 0, centroid);
        double u03 = ImageMoments.getCentralMoment(fastBitmap, 0, 3, centroid);
        double u20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0, centroid);
        double u02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2, centroid);
        double skx = u30 / Math.pow(u20, 1.5);
        double sky = u03 / Math.pow(u02, 1.5);
        return new DoublePoint(skx, sky);
    }

    public static DoublePoint getProjectionKurtosis(FastBitmap fastBitmap) {
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap);
        return ImageMoments.getProjectionKurtosis(fastBitmap, centroid);
    }

    public static DoublePoint getProjectionKurtosis(FastBitmap fastBitmap, DoublePoint centroid) {
        double u40 = ImageMoments.getCentralMoment(fastBitmap, 4, 0, centroid);
        double u20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0, centroid);
        double u04 = ImageMoments.getCentralMoment(fastBitmap, 0, 4, centroid);
        double u02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2, centroid);
        double skx = u40 / Math.pow(u20, 2.0) - 3.0;
        double sky = u04 / Math.pow(u02, 2.0) - 3.0;
        return new DoublePoint(skx, sky);
    }

    public static double getNormalizedCentralMoment(FastBitmap fastBitmap, int p, int q) {
        double m00 = ImageMoments.getCentralMoment(fastBitmap, 0, 0);
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap, m00);
        return ImageMoments.getNormalizedCentralMoment(fastBitmap, p, q, centroid, m00);
    }

    public static double getNormalizedCentralMoment(FastBitmap fastBitmap, int p, int q, DoublePoint centroid, double m00) {
        double gama = (p + q) / 2 + 1;
        double mpq = ImageMoments.getCentralMoment(fastBitmap, p, q, centroid);
        double m00gama = Math.pow(m00, gama);
        if (m00gama == 0.0) {
            return 0.0;
        }
        return mpq / m00gama;
    }

    public static double getZaidNormalizedCentralMoment(FastBitmap fastBitmap, int p, int q) {
        double mpq = ImageMoments.getCentralMoment(fastBitmap, p, q);
        double m00 = ImageMoments.getCentralMoment(fastBitmap, 0, 0);
        double m20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0);
        double m02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2);
        return mpq * (1.0 / m00) * Math.pow(m00 / (m20 + m02), (p + q) / 2);
    }
}

