/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Statistics.HistogramStatistics;

public class ImageHistogram {
    private int[] values;
    private double mean = 0.0;
    private double stdDev = 0.0;
    private double entropy = 0.0;
    private double kurtosis = 0.0;
    private double skewness = 0.0;
    private int median = 0;
    private int mode;
    private int min;
    private int max;
    private long total;

    public static int[] MatchHistograms(int[] histA, int[] histB) {
        int length = histA.length;
        double[] PA = ImageHistogram.CDF(histA);
        double[] PB = ImageHistogram.CDF(histB);
        int[] F = new int[length];
        for (int a = 0; a < length; ++a) {
            int j = length - 1;
            do {
                F[a] = j--;
            } while (j >= 0 && PA[a] <= PB[j]);
        }
        return F;
    }

    public static int[] MatchHistograms(ImageHistogram histA, ImageHistogram histB) {
        return ImageHistogram.MatchHistograms(histA.values, histB.values);
    }

    public static double[] CDF(int[] values) {
        int length = values.length;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            n += values[i];
        }
        double[] P = new double[length];
        int c = values[0];
        P[0] = (double)c / (double)n;
        for (int i = 1; i < length; ++i) {
            P[i] = (double)(c += values[i]) / (double)n;
        }
        return P;
    }

    public static double[] CDF(ImageHistogram hist) {
        return ImageHistogram.CDF(hist.values);
    }

    public static double[] Normalize(int[] values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        double[] norm = new double[values.length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = (double)values[i] / (double)sum;
        }
        return norm;
    }

    public ImageHistogram(int[] values) {
        this.values = values;
        this.update();
    }

    public int[] getValues() {
        return this.values;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public double getKurtosis() {
        return this.kurtosis;
    }

    public double getSkewness() {
        return this.skewness;
    }

    public int getMedian() {
        return this.median;
    }

    public int getMode() {
        return this.mode;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }

    private void update() {
        this.total = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            this.total += (long)this.values[i];
        }
        this.mean = HistogramStatistics.Mean(this.values);
        this.stdDev = HistogramStatistics.StdDev(this.values, this.mean);
        this.kurtosis = HistogramStatistics.Kurtosis(this.values, this.mean, this.stdDev);
        this.skewness = HistogramStatistics.Skewness(this.values, this.mean, this.stdDev);
        this.median = HistogramStatistics.Median(this.values);
        this.mode = HistogramStatistics.Mode(this.values);
        this.entropy = HistogramStatistics.Entropy(this.values);
    }

    public double[] Normalize() {
        double[] h = new double[this.values.length];
        for (int i = 0; i < h.length; ++i) {
            h[i] = (double)this.values[i] / (double)this.total;
        }
        return h;
    }
}

