/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.DoublePoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageMoments;

public class HuMoments {
    private boolean normalize;

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public HuMoments() {
        this(false);
    }

    public HuMoments(boolean normalize) {
        this.normalize = normalize;
    }

    public double[] Compute(FastBitmap fastBitmap) {
        double[] moments = new double[8];
        double m00 = ImageMoments.getRawMoment(fastBitmap, 0, 0);
        DoublePoint centroid = ImageMoments.getCentroid(fastBitmap, m00);
        double n20 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 2, 0, centroid, m00);
        double n02 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 0, 2, centroid, m00);
        double n30 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 3, 0, centroid, m00);
        double n12 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 1, 2, centroid, m00);
        double n21 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 2, 1, centroid, m00);
        double n03 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 0, 3, centroid, m00);
        double n11 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 1, 1, centroid, m00);
        moments[0] = n20 + n02;
        moments[1] = Math.pow(n20 - n02, 2.0) + 4.0 * Math.pow(n11, 2.0);
        moments[2] = Math.pow(n30 - 3.0 * n12, 2.0) + Math.pow(3.0 * n21 - n03, 2.0);
        moments[3] = Math.pow(n30 + n12, 2.0) + Math.pow(n12 + n03, 2.0);
        moments[4] = (n30 - 3.0 * n12) * (n30 + n12) * (Math.pow(n30 + n12, 2.0) - 3.0 * Math.pow(n21 + n03, 2.0)) + (3.0 * n21 - n03) * (n21 + n03) * (3.0 * Math.pow(n30 + n12, 2.0) - Math.pow(n21 + n03, 2.0));
        moments[5] = (n20 - n02) * (Math.pow(n30 + n12, 2.0) - Math.pow(n21 + n03, 2.0)) + 4.0 * n11 * (n30 + n12) * (n21 + n03);
        moments[6] = (3.0 * n21 - n03) * (n30 + n12) * (Math.pow(n30 + n12, 2.0) - 3.0 * Math.pow(n21 + n03, 2.0)) + (n30 - 3.0 * n12) * (n21 + n03) * (3.0 * Math.pow(n30 + n12, 2.0) - Math.pow(n21 + n03, 2.0));
        moments[7] = n11 * (Math.pow(n30 + n12, 2.0) - Math.pow(n03 + n21, 2.0)) - (n20 - n02) * (n30 + n12) * (n03 + n21);
        if (this.normalize) {
            for (int i = 0; i < moments.length; ++i) {
                moments[i] = Math.signum(moments[i]) * Math.log10(1.0 + Math.abs(moments[i]));
            }
        }
        return moments;
    }
}

