/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.HoughLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HoughLineTransformation {
    int radius = 4;
    final int maxTheta = 180;
    double thetaStep = Math.PI / 180;
    int stepsPerDegree = 1;
    int minIntensity = 0;
    int maxIntensity = Integer.MAX_VALUE;
    boolean sort = true;
    protected int width;
    protected int height;
    protected int[][] houghArray;
    protected float centerX;
    protected float centerY;
    protected int houghHeight;
    protected int doubleHeight;
    protected int numPoints;
    private double[] sinCache;
    private double[] cosCache;

    public HoughLineTransformation() {
    }

    public HoughLineTransformation(int minIntensity) {
        this.minIntensity = Math.max(1, minIntensity);
    }

    public HoughLineTransformation(int minIntensity, int maxIntensity) {
        this.minIntensity = Math.max(1, minIntensity);
        this.maxIntensity = Math.max(1, maxIntensity);
    }

    public HoughLineTransformation(int minIntensity, int maxIntensity, boolean sort) {
        this.minIntensity = Math.max(1, minIntensity);
        this.maxIntensity = Math.max(1, maxIntensity);
        this.sort = sort;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getIntensity() {
        return this.minIntensity;
    }

    public void setIntensity(int intensity) {
        this.minIntensity = Math.max(1, intensity);
    }

    public int getStepsPerDegree() {
        return this.stepsPerDegree;
    }

    public void setStepsPerDegree(int stepsPerDegree) {
        this.stepsPerDegree = stepsPerDegree;
        stepsPerDegree = Math.max(1, Math.min(10, stepsPerDegree));
        this.houghHeight = 180 * stepsPerDegree;
        this.thetaStep = Math.PI / (double)this.houghHeight;
        this.sinCache = new double[this.houghHeight];
        this.cosCache = new double[this.houghHeight];
        for (int i = 0; i < this.houghHeight; ++i) {
            this.sinCache[i] = Math.sin((double)i * this.thetaStep);
            this.cosCache[i] = Math.cos((double)i * this.thetaStep);
        }
    }

    private void init() {
        this.houghHeight = (int)(Math.sqrt(2.0) * (double)Math.max(this.height, this.width)) / 2;
        this.doubleHeight = 2 * this.houghHeight;
        this.houghArray = new int[180][this.doubleHeight];
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.numPoints = 0;
        this.sinCache = new double[180];
        this.cosCache = (double[])this.sinCache.clone();
        for (int t = 0; t < 180; ++t) {
            double realTheta = (double)t * this.thetaStep;
            this.sinCache[t] = Math.sin(realTheta);
            this.cosCache[t] = Math.cos(realTheta);
        }
    }

    public void ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.width = fastBitmap.getWidth();
            this.height = fastBitmap.getHeight();
            this.init();
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    if (fastBitmap.getGray(x, y) != 255) continue;
                    this.addPoint(x, y);
                }
            }
        } else {
            try {
                throw new IllegalArgumentException("HoughLineTransformation only works with grayscale images.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addEdgePoints(ArrayList<IntPoint> edgePoints) {
        for (IntPoint point : edgePoints) {
            this.addPoint(point.x, point.y);
        }
    }

    private void addPoint(int x, int y) {
        for (int t = 0; t < 180; ++t) {
            int r = (int)((double)((float)x - this.centerX) * this.cosCache[t] + (double)((float)y - this.centerY) * this.sinCache[t]);
            if ((r += this.houghHeight) < 0 || r >= this.doubleHeight) continue;
            int[] nArray = this.houghArray[t];
            int n = r;
            nArray[n] = nArray[n] + 1;
        }
        ++this.numPoints;
    }

    public List<HoughLine> getLines() {
        ArrayList<HoughLine> lines = new ArrayList<HoughLine>();
        if (this.numPoints == 0) {
            return lines;
        }
        double max = this.getMaximumValue();
        for (int t = 0; t < 180; ++t) {
            block1: for (int r = this.radius; r < this.doubleHeight - this.radius; ++r) {
                if (this.houghArray[t][r] <= this.minIntensity || this.houghArray[t][r] >= this.maxIntensity) continue;
                int peak = this.houghArray[t][r];
                for (int dx = -this.radius; dx <= this.radius; ++dx) {
                    for (int dy = -this.radius; dy <= this.radius; ++dy) {
                        int dt = t + dx;
                        int dr = r + dy;
                        if (dt < 0) {
                            dt += 180;
                        } else if (dt >= 180) {
                            dt -= 180;
                        }
                        if (this.houghArray[dt][dr] > peak) continue block1;
                    }
                }
                double theta = (double)t * this.thetaStep;
                lines.add(new HoughLine(theta, r, peak, (double)peak / max));
            }
        }
        if (this.sort) {
            Collections.sort(lines);
        }
        return lines;
    }

    private int getMaximumValue() {
        int max = 0;
        for (int t = 0; t < 180; ++t) {
            for (int r = 0; r < this.doubleHeight; ++r) {
                if (this.houghArray[t][r] <= max) continue;
                max = this.houghArray[t][r];
            }
        }
        return max;
    }

    public FastBitmap getHoughArrayImage() {
        int max = this.getMaximumValue();
        FastBitmap fastBitmap = new FastBitmap(180, this.doubleHeight);
        for (int t = 0; t < 180; ++t) {
            for (int r = 0; r < this.doubleHeight; ++r) {
                double value = 255.0 * (double)this.houghArray[t][r] / (double)max;
                int v = 255 - (int)value;
                fastBitmap.setRGB(r, t, v, v, v);
            }
        }
        return fastBitmap;
    }
}

