/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import java.util.ArrayList;

public class HistogramOfOrientedGradients {
    private int numberOfBins = 9;
    private int cellSize = 6;
    private int blockSize = 3;
    private double epsilon = 1.0E-10;
    private double binWidth = 0.6981317007977318;

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public HistogramOfOrientedGradients() {
    }

    public HistogramOfOrientedGradients(int numberOfBins, int blockSize, int cellSize) {
        this.numberOfBins = numberOfBins;
        this.blockSize = blockSize;
        this.cellSize = cellSize;
        this.binWidth = Math.PI * 2 / (double)numberOfBins;
    }

    public ArrayList<double[]> ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            float[][] direction = new float[height][width];
            float[][] magnitude = new float[height][width];
            for (int i = 1; i < height - 1; ++i) {
                for (int j = 1; j < width - 1; ++j) {
                    int p1 = fastBitmap.getGray(i - 1, j + 1);
                    int p2 = fastBitmap.getGray(i, j + 1);
                    int p3 = fastBitmap.getGray(i + 1, j + 1);
                    int p4 = fastBitmap.getGray(i - 1, j - 1);
                    int p5 = fastBitmap.getGray(i, j - 1);
                    int p6 = fastBitmap.getGray(i + 1, j - 1);
                    int p7 = fastBitmap.getGray(i + 1, j);
                    int p8 = fastBitmap.getGray(i - 1, j);
                    float h = (float)(p1 + p2 + p3 - (p4 + p5 + p6)) * 0.16666667f;
                    float v = (float)(p6 + p7 + p3 - (p4 + p8 + p1)) * 0.16666667f;
                    direction[i][j] = (float)Math.atan2(v, h);
                    magnitude[i][j] = (float)Math.sqrt(h * h + v * v);
                }
            }
            int cellCountX = (int)Math.floor((double)height / (double)this.cellSize);
            int cellCountY = (int)Math.floor((double)width / (double)this.cellSize);
            double[][][] histograms = new double[cellCountX][cellCountY][];
            for (int i = 0; i < cellCountX; ++i) {
                for (int j = 0; j < cellCountY; ++j) {
                    double[] histogram = new double[this.numberOfBins];
                    int startCellX = i * this.cellSize;
                    int startCellY = j * this.cellSize;
                    for (int x = 0; x < this.cellSize; ++x) {
                        for (int y = 0; y < this.cellSize; ++y) {
                            int bin;
                            double ang = direction[startCellX + x][startCellY + y];
                            double mag = magnitude[startCellX + x][startCellY + y];
                            int n = bin = (int)Math.floor((ang + Math.PI) * this.binWidth);
                            histogram[n] = histogram[n] + mag;
                        }
                    }
                    histograms[i][j] = histogram;
                }
            }
            int blocksCountX = (int)Math.floor((double)cellCountX / (double)this.blockSize);
            int blocksCountY = (int)Math.floor((double)cellCountY / (double)this.blockSize);
            ArrayList<double[]> blocks = new ArrayList<double[]>();
            for (int i = 0; i < blocksCountX; ++i) {
                for (int j = 0; j < blocksCountY; ++j) {
                    double[] v = new double[this.blockSize * this.blockSize * this.numberOfBins];
                    int startBlockX = i * this.blockSize;
                    int startBlockY = j * this.blockSize;
                    int c = 0;
                    for (int x = 0; x < this.blockSize; ++x) {
                        for (int y = 0; y < this.blockSize; ++y) {
                            double[] histogram = histograms[startBlockX + x][startBlockY + y];
                            for (int k = 0; k < histogram.length; ++k) {
                                v[c++] = histogram[k];
                            }
                        }
                    }
                    double[] block = this.Divide(v, this.Euclidean(v) + this.epsilon);
                    blocks.add(block);
                }
            }
            return blocks;
        }
        throw new IllegalArgumentException("HistogramOfOrientedGradients only works in grayscale images.");
    }

    private double Euclidean(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * a[i];
        }
        return Math.sqrt(sum);
    }

    private double[] Divide(double[] vector, double x) {
        double[] r = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            r[i] = vector[i] / x;
        }
        return r;
    }
}

